package com.huigou.bpm.webservice.call.sapclient;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DestinationDataProviderImp implements DestinationDataProvider {

    private Map provider = new HashMap();

    public void addDestinationProperties(String destName,Properties props){
        provider.put(destName, props);
    }

    @Override
    public Properties getDestinationProperties(String destName) throws DataProviderException {
        if (destName == null){
            throw new NullPointerException("Destinantion name is empty.");
        }

        if (provider.size() == 0){
            throw new IllegalStateException("Data provider is empty.");
        }

        return (Properties) provider.get(destName);
    }

    @Override
    public boolean supportsEvents() {
        return false;
    }

    @Override
    public void setDestinationDataEventListener(DestinationDataEventListener destinationDataEventListener) {
        throw new UnsupportedOperationException();
    }
}
