package com.huigou.bpm.webservice.call.domain.model;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * WebService 参数配置信息
 */
@Entity
@Table(name="TBPM_WEB_SERVICE_SAP_PARAMETER")
@Getter@Setter
public class SapWebServiceParameter extends AbstractEntity {
    /**
     * 接口配置ID
     */
    @Column(name = "CONFIG_ID")
    private String configId;
    /**
     * 参数名称
     */
    @Column(name = "PARAMETER_NAME")
    private String parameterName;
    /**
     * 本地系统参数名称
     */
    @Column(name = "LOCAL_PARAMETER_NAME")
    private String localParameterName;
    /**
     * 参数类名
     */
    @Column(name = "PARAMETER_CLASS")
    private String parameterClass;
    /**
     * 参数类 包路径
     */
    @Column(name = "PARAMETER_PACKAGE")
    private String parameterPackage;
    /**
     * WebService接口，传递参数类型 simple,custom,customList
     * simple:简单基础类型，如 int,String,float
     * custom:自定义类型
     * customList:自定义数组类型
     */
    @Column(name = "TYPE")
    private String type;
    /**
     * 父级ID
     */
    @Column(name = "PARENT_ID")
    private String parentId;
    /**
     * 参数传递类型 IN,OUT,INOUT
     */
    @Column(name = "CALL_TYPE")
    private String callType;
    /**
     * 序列
     */
    @Column(name = "SEQUENCE")
    private Integer sequence;
    /**
     * 状态
     */
    @Column(name="STATUS")
    private Integer status;
    /**
     * 备注
     */
    @Column(name="REMARK")
    private String remark;
}
