package com.huigou.bpm.webservice.application.impl;

import com.huigou.bpm.webservice.application.WebServiceConfigTypeApplication;
import com.huigou.bpm.webservice.domain.model.WebServiceConfigType;
import com.huigou.bpm.webservice.domain.query.OtherSystemConfigQueryRequest;
import com.huigou.bpm.webservice.domain.query.WebServiceConfigTypeQueryRequest;
import com.huigou.bpm.webservice.repository.WebServiceConfigTypeRepository;
import com.huigou.cache.DictUtil;
import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

@Service("webServiceConfigTypeApplication")
public class WebServiceConfigTypeApplicationImpl extends FlowBroker implements WebServiceConfigTypeApplication {

    @Autowired
    private WebServiceConfigTypeRepository webServiceConfigTypeRepository;

    @Override
    public Map<String, Object> slicedQueryWebServiceConfigType(WebServiceConfigTypeQueryRequest request) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH,QUERY_WEBSERVICE_CONFIG_TYPE);
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor,request);
        queryModel.putDictionary("isEnableRule", DictUtil.getDictionary("yesorno"));
        return this.sqlExecutorDao.executeQuery(queryModel);
    }

    @Override
    public void saveWebServiceConfigType(WebServiceConfigType webServiceConfigType) {
        checkCodeConstraints(webServiceConfigType);
        webServiceConfigTypeRepository.save(webServiceConfigType);
    }

    @Override
    @Transactional
    public void updateWebServiceTypeStatus(List<String> ids, Integer status) {
        checkIdsNotEmpty(ids);
        Assert.notNull(status, String.format(CommonDomainConstants.PARAMETER_NOT_NULL_FORMAT, CommonDomainConstants.STATUS_FIELD_NAME));
        commonDomainService.updateStatus(WebServiceConfigType.class,ids,status);
    }

    @Override
    public void deleteWebServiceType(List<String> ids) {
        checkIdsNotEmpty(ids);
        List<WebServiceConfigType> configTypes = webServiceConfigTypeRepository.findAll(ids);
        webServiceConfigTypeRepository.delete(configTypes);
    }

    @Override
    public WebServiceConfigType findByCode(String code) {
        return webServiceConfigTypeRepository.findByCode(code);
    }

    /**
     * 检查Code约束条件，不能重复
     * @param webServiceConfigType
     */
    private void checkCodeConstraints(WebServiceConfigType webServiceConfigType){
        String id = webServiceConfigType.getId();
        if(StringUtil.isBlank(id)){
            id="-";
        }
        Integer count = webServiceConfigTypeRepository.countByCodeAndIdIsNot(webServiceConfigType.getCode(),id);
        Assert.isTrue(count==0,"编码不能重复！");
    }
}
