package com.huigou.bpm.webservice.application;

import com.huigou.bpm.webservice.domain.model.WebServiceConfigType;
import com.huigou.bpm.webservice.domain.query.WebServiceConfigTypeQueryRequest;

import java.util.List;
import java.util.Map;

public interface WebServiceConfigTypeApplication {

    /*
     * 查询文件
     */
    String QUERY_XML_FILE_PATH = "config/webservice/webServiceConfigType.xml";
    /**
     * query SQL NAME
     */
    String QUERY_WEBSERVICE_CONFIG_TYPE = "webServiceConfigType";

    /**
     * 分页查询WebService接口类型配置
     * @param request
     * @return
     */
    Map<String, Object> slicedQueryWebServiceConfigType(WebServiceConfigTypeQueryRequest request);

    /**
     * 保存WebService接口类型配置
     * @param webServiceConfigType
     */
    void saveWebServiceConfigType(WebServiceConfigType webServiceConfigType);

    /**
     * 修改接口类型状态
     * @param ids
     * @param status
     */
    void updateWebServiceTypeStatus(List<String> ids,Integer status);

    /**
     * 删除webService接口类型
     * @param ids
     */
    void deleteWebServiceType(List<String> ids);

    WebServiceConfigType findByCode(String code);
}
