package com.huigou.uasp.resolver;

import com.huigou.domain.QueryRequest;
import com.huigou.util.SDO;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

import javax.servlet.http.HttpServletRequest;

/**
 * 绑定QueryRequest到springmvc控制器的方法参数。
 *
 * @author yonghuan
 */
public class QueryRequestMethodArgumentResolver extends SdoHandlerMethodArgumentResolver {

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return QueryRequest.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        SDO sdo = getSDO(webRequest.getNativeRequest(HttpServletRequest.class));
        Object queryRequest = sdo.toQueryRequest(parameter.getParameterType());
        return queryRequest;
    }

}
