package com.huigou.rule.application;

import com.huigou.rule.domain.model.Rule;
import com.huigou.rule.domain.query.RuleQueryRequest;

import java.util.List;
import java.util.Map;

public interface RuleApplication {

    /**
     * 保存规则配置
     * @param rule
     */
    void saveRule(Rule rule);

    /**
     * 分页查询规则配置
     * @param request
     * @return
     */
    Map<String, Object> slicedQueryRules(RuleQueryRequest request);

    /**
     * 修改配置状态
     * @param ids
     * @param status
     */
    void updateRuleStatus(List<String> ids, Integer status);

    void moveRules(List<String> ids, String folderId);

    /**
     * 删除配置
     * @param ids
     */
    void deleteRule(List<String> ids);

    /**
     * 根据code查询规则
     * @param code
     * @return
     */
    Rule findByCode(String code);

    /**
     * 部署业务规则到流程引擎
     */
    void deployToBpmEngine(List<String> ids);
}
