package com.huigou.uasp.model.domain.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.Creator;
import com.huigou.data.domain.model.Modifier;
import com.huigou.data.domain.model.TreeEntity;

/**
 * 
 * @ClassName DbTables
 * @author lxh
 * @date 2019年7月25日 下午2:16:44
 * @Description TODO
 */
@Entity
@Table(name = "SAF_TABLES")
@EntityListeners({ CreatorAndModifierListener.class })
public class DbTables extends TreeEntity{
	
	private static final long serialVersionUID = 1L;

	@Column(name="TABLE_NAME",length=128)
	private String tableName;//表名
	
	//@Column(name="NAME",length=256)
	//private String name;//表中文名称
	
	@Column(name="DESCRIPTIONS",length=32)
	private String descriptions;//描述
	
//	@Column(name="PARENT_ID",length=32)
//	private String parentId;//父ID
	
	@Column(name="PRIMARY_KEY",length=128)
	private String primartKey;//主键字段名称
	
	@Column(name="TITLE",length=128)
	private String title;//显示标题字段
	
	@Column(name="TABLE_TYPE")
	private String tableType;//表类型 1、字典表 2、基础表 3、审批表 
	
	@Column(name="TYPE",length=32)
	private String type;//数据类型 1表示分类  2表示表名
	
	@Column(name = "PUBLISHED", length = 10)
	private Integer published; 
	
	/**
	 * 创建人信息
	 */
	@Embedded
	private Creator creator;
	
	/**
	 * 最后修改人信息
	 */
	@Embedded
	private Modifier modifier;

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	

	public String getDescriptions() {
		return descriptions;
	}

	public void setDescriptions(String descriptions) {
		this.descriptions = descriptions;
	}

	
	public String getPrimartKey() {
		return primartKey;
	}

	public void setPrimartKey(String primartKey) {
		this.primartKey = primartKey;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	

	public String getTableType() {
		return tableType;
	}

	public void setTableType(String tableType) {
		this.tableType = tableType;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Creator getCreator() {
		return creator;
	}

	public void setCreator(Creator creator) {
		this.creator = creator;
	}

	public Modifier getModifier() {
		return modifier;
	}

	public void setModifier(Modifier modifier) {
		this.modifier = modifier;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Integer getPublished() {
		return published;
	}

	public void setPublished(Integer published) {
		this.published = published;
	}
	
	

	
}
