package com.huigou.uasp.meta.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.huigou.uasp.meta.domain.model.MetaData;

import java.util.List;


public interface MetaDataRepository extends JpaRepository<MetaData, String> {
 /*  说明：
       1)、原生sql访问方式：
   @Query(value = "SELECT PM.* FROM PM_MESSAGE PM WHERE PM.ID IN (SELECT PMR.MESSAGE_ID FROM PM_MESSAGE_RECEIVER PMR WHERE PMR.RECEIVER_ID = ?1)",nativeQuery = true)
    List<Message> findById(String personId);
      2)、HQL访问方式：
   @Query("from Propertyclass s where  s.pmId=?1 and propertyClassid=?2 ") 
    List <Propertyclass> searchPropertyClassDetails(String pmId,String classId);
     3)、通过方法名称生成查询  （参见JPA访问数据库方式）
    List <Message>  findById(String id);
   @Modifying注解    
   @Query("UPDATE User u SET u.name = :name WHERE u.id = :id")
  void updateTable(@Param("name") String name, @Param("id")Integer id);
   @Modifying注解    
   @Query("delete from User u WHERE u.id in :idList")    
  void deleteByIds(@Param("idList")List<Integer> idList);  
  */

    List<MetaData> findById(String id);

    MetaData findByFieldCode(String fieldCode);

    MetaData findByClassifyIdAndFieldCode(String classifyId,String fieldCode);

    List<MetaData> findByClassifyIdIn(List<String> ids);

    @Query(value = "select t from MetaData t where t.status=1 and t.classifyId = ?1")
    List<MetaData> findByClassifyId(String id);

    @Query(value = "select t from MetaData t where t.status=1 and t.classifyId = ?1 and t.fieldName = ?2 ")
    MetaData findByClassifyIdAndfAndFieldName(String id,String name);
}
