package com.huigou.uasp.meta.repository;

        import org.springframework.data.jpa.repository.JpaRepository;

        import java.util.List;



        import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.huigou.uasp.meta.domain.model.BusinessType;

@Repository
public interface BusinessTypeRepository extends JpaRepository<BusinessType, String> {
    /*  说明：
          1)、原生sql访问方式：
      @Query(value = "SELECT PM.* FROM PM_MESSAGE PM WHERE PM.ID IN (SELECT PMR.MESSAGE_ID FROM PM_MESSAGE_RECEIVER PMR WHERE PMR.RECEIVER_ID = ?1)",nativeQuery = true)
       List<Message> findById(String personId);
         2)、HQL访问方式：
      @Query("from Propertyclass s where  s.pmId=?1 and propertyClassid=?2 ")
       List <Propertyclass> searchPropertyClassDetails(String pmId,String classId);
        3)、通过方法名称生成查询  （参见JPA访问数据库方式）
       List <Message>  findById(String id);
      @Modifying注解
      @Query("UPDATE User u SET u.name = :name WHERE u.id = :id")
     void updateTable(@Param("name") String name, @Param("id")Integer id);
      @Modifying注解
      @Query("delete from User u WHERE u.id in :idList")
     void deleteByIds(@Param("idList")List<Integer> idList);
     */
    @Query
    List<BusinessType> findById(String id);
    @Query(value = "select t from BusinessType t where t.parentId=?1")
    List<BusinessType> findByParentId(String parentId);
    //    SELECT *
//    FROM district
//    START WITH NAME ='巴中市'
//    CONNECT BY PRIOR ID=parent_id
    @Query(value = "select t from BusinessType t where t.fullId like ?1%")
    List<BusinessType> findByFullId(String fullId);


}
