package com.huigou.uasp.meta.domain.model;

import com.huigou.data.domain.model.AbstractEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "MDM_META_DATA_DICT")
public class MetaDataDICT extends AbstractEntity {
    /**
     * 分类ID
     */
    @Column(name = "classify_id", length = 32)
    private String classifyId;
    /**
     * 元数据ID
     */
    @Column(name = "meta_data_id", length = 32)
    private String metaDataId;
    /**
     * 数据字典名称
     */
    @Column(name = "dict_name", length = 64)
    private String dictName;
    /**
     * 数据字典CODE
     */
    @Column(name = "dict_code", length = 32)
    private String dictCode;
    /**
     * 备注
     */
    @Column(name = "remark", length = 1000)
    private String remark;
    /**
     * 创建人ID
     */
    @Column(name = "created_by_id", length = 100)
    private String createdById;
    /**
     * 创建人名称
     */
    @Column(name = "created_by_name", length = 100)
    private String createdByName;

    public String getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(String classifyId) {
        this.classifyId = classifyId;
    }

    public String getMetaDataId() {
        return metaDataId;
    }

    public void setMetaDataId(String metaDataId) {
        this.metaDataId = metaDataId;
    }

    public String getDictName() {
        return dictName;
    }

    public void setDictName(String dictName) {
        this.dictName = dictName;
    }

    public String getDictCode() {
        return dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreatedById() {
        return createdById;
    }

    public void setCreatedById(String createdById) {
        this.createdById = createdById;
    }

    public String getCreatedByName() {
        return createdByName;
    }

    public void setCreatedByName(String createdByName) {
        this.createdByName = createdByName;
    }
}
