package com.huigou.uasp.meta.domain.model;

import javax.persistence.*;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;

@Entity
@Table(name = "saf_meta_data")
@EntityListeners({CreatorAndModifierListener.class})
public class MetaData extends AbstractEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 分类ID
	 */
	@Column(name = "classify_id", length = 32)
	private String classifyId;

	/**
	 * 字段中文名称
	 */
	@Column(name = "field_name", length = 100)
	private String fieldName;


	/**
	 * 字段英文名称
	 */
	@Column(name = "field_engname", length = 100)
	private String fieldEngname;


	/**
	 * 字段CODE
	 */
	@Column(name = "field_code", length = 100)
	private String fieldCode;


	/**
	 * 字段类型(数据库常见类型)
	 */
	@Column(name = "field_data_type", length = 100)
	private String fieldDataType;


	/**
	 * 字段长度
	 */
	@Column(name = "field_length", length = 22)
	private Integer fieldLength;


	/**
	 * 字段精确度
	 */
	@Column(name = "field_decimal", length = 22)
	private Integer fieldDecimal;


	/**
	 * 字段注释
	 */
	@Column(name = "field_notes", length = 200)
	private String fieldNotes;


	/**
	 * 编码字段的编码规则ID
	 */
	@Column(name = "code_rule_id", length = 32)
	private String codeRuleId;


	/**
	 * 是否为空(是1否0)
	 */
	@Column(name = "is_null", length = 22)
	private Integer isNull;

	/*
	 * 是否主键
	 */
	@Column(name = "is_primary_key", length = 10)
	private Integer isPrimaryKey;

	/**
	 * 默认值
	 */
	@Column(name = "default_value", length = 100)
	private String defaultValue;


	/**
	 * 备注
	 */
	@Column(name = "remark", length = 1000)
	private String remark;

	/**
	 * 是否有效(是1否0)
	 */
	@Column(name = "status", length = 10)
	private Integer status;

	/**
	 * 是否隐藏(是1否0)
	 */
	@Column(name = "is_hidden", length = 10)
	private Integer isHidden;


	/**
	 * 创建人信息
	 */
	@Embedded
	private Creator creator;

	/**
	 * 排序类型
	 */
	@Column(name = "SORT_TYPE")
	private String sortType;

	@Transient
	private String sortTypeTextView;

	public String getSortTypeTextView() {
		return sortTypeTextView;
	}

	public void setSortTypeTextView(String sortTypeTextView) {
		this.sortTypeTextView = sortTypeTextView;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Integer getIsPrimaryKey() {
		return isPrimaryKey;
	}

	public void setIsPrimaryKey(Integer isPrimaryKey) {
		this.isPrimaryKey = isPrimaryKey;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getClassifyId() {
		return classifyId;
	}

	public void setClassifyId(String classifyId) {
		this.classifyId = classifyId;
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public String getFieldEngname() {
		return fieldEngname;
	}

	public void setFieldEngname(String fieldEngname) {
		this.fieldEngname = fieldEngname;
	}

	public String getFieldCode() {
		return fieldCode;
	}

	public void setFieldCode(String fieldCode) {
		this.fieldCode = fieldCode;
	}

	public String getFieldDataType() {
		return fieldDataType;
	}

	public void setFieldDataType(String fieldDataType) {
		this.fieldDataType = fieldDataType;
	}

	public Integer getFieldLength() {
		return fieldLength;
	}

	public void setFieldLength(Integer fieldLength) {
		this.fieldLength = fieldLength;
	}

	public Integer getFieldDecimal() {
		return fieldDecimal;
	}

	public void setFieldDecimal(Integer fieldDecimal) {
		this.fieldDecimal = fieldDecimal;
	}

	public String getFieldNotes() {
		return fieldNotes;
	}

	public void setFieldNotes(String fieldNotes) {
		this.fieldNotes = fieldNotes;
	}

	public String getCodeRuleId() {
		return codeRuleId;
	}

	public void setCodeRuleId(String codeRuleId) {
		this.codeRuleId = codeRuleId;
	}

	public Integer getIsNull() {
		return isNull;
	}

	public void setIsNull(Integer isNull) {
		this.isNull = isNull;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getIsHidden() {
		return isHidden;
	}

	public void setIsHidden(Integer isHidden) {
		this.isHidden = isHidden;
	}



}
