package com.huigou.uasp.meta.domain.model;
 import javax.persistence.Column;
 import javax.persistence.Embedded;
 import javax.persistence.Entity;
 import javax.persistence.EntityListeners;
 import javax.persistence.Table;
 import com.huigou.data.domain.listener.CreatorAndModifierListener;
 import com.huigou.data.domain.model.AbstractEntity;
 import com.huigou.data.domain.model.Creator;
  
 @Entity
 @Table(name = "mdm_business_type") 
@EntityListeners({ CreatorAndModifierListener.class }) 
public class BusinessType extends AbstractEntity{ 
   private static final long serialVersionUID = 1L; 
 /** 
  * 父级ID
 */
  @Column(name="parent_id",length=32) 
  private String parentId; 
  
 public String getParentId() { 
     return parentId; 
 } 
 public void setParentId(String  parentId) { 
   this.parentId = parentId; 
  } 
 /** 
  * 分类名称
 */
  @Column(name="name",length=100) 
  private String name; 
  
 public String getName() { 
     return name; 
 } 
 public void setName(String  name) { 
   this.name = name; 
  } 
 /** 
  * 分类编码
 */
  @Column(name="code",length=100) 
  private String code; 
  
 public String getCode() { 
     return code; 
 } 
 public void setCode(String  code) { 
   this.code = code; 
  } 
 /** 
  * 全路径ID
 */
  @Column(name="full_id",length=1000) 
  private String fullId; 
  
 public String getFullId() { 
     return fullId; 
 } 
 public void setFullId(String  fullId) { 
   this.fullId = fullId; 
  } 
 /** 
  * 全路径名称
 */
  @Column(name="full_name",length=1000) 
  private String fullName; 
  
 public String getFullName() { 
     return fullName; 
 } 
 public void setFullName(String  fullName) { 
   this.fullName = fullName; 
  } 
 /** 
  * 备注
 */
  @Column(name="remark",length=1000) 
  private String remark; 
  
 public String getRemark() { 
     return remark; 
 } 
 public void setRemark(String  remark) { 
   this.remark = remark; 
  } 
 /** 
  * 是否有效(是1否0)
 */
  @Column(name="status",length=22) 
  private Integer status; 
  
 public Integer getStatus() { 
     return status; 
 } 
 public void setStatus(Integer  status) { 
   this.status = status; 
  } 
 /** 
  * 顺序号
 */
  @Column(name="sequence",length=22) 
  private Integer sequence; 
  
 public Integer getSequence() { 
     return sequence; 
 } 
 public void setSequence(Integer  sequence) { 
   this.sequence = sequence; 
  } 
 /** 
  * 节点类型（0 根节点 1 中间节点 2 末级节点）
 */
  @Column(name="node_type",length=22) 
  private Integer nodeType; 
  
 public Integer getNodeType() { 
     return nodeType; 
 } 
 public void setNodeType(Integer  nodeType) { 
   this.nodeType = nodeType; 
  } 
  /** 
 * 创建人信息 
 */ 
  @Embedded 
 private Creator creator; 
}
