package com.huigou.uasp.form.domain.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.lang.Double;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;
import com.huigou.uasp.form.model.ueform.field.FormField;
import com.huigou.uasp.form.model.ueform.field.Select;
import com.huigou.uasp.form.model.ueform.field.SelectOption;
import com.huigou.uasp.form.model.ueform.field.Text;
//import com.huigou.uasp.form.pojo.UeForm;
import com.huigou.uasp.util.Utils;

@Entity
@Table(name = "saf_form_list")
public class SafFormslist extends AbstractEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 表单编号
	 */
	@Column(name = "form_no", length = 100)
	private String formNo;

	public String getFormNo() {
		return formNo;
	}

	public void setFormNo(String formNo) {
		this.formNo = formNo;
	}

	/**
	 * 表单名称
	 */
	@Column(name = "form_name", length = 100)
	private String formName;

	public String getFormName() {
		return formName;
	}

	public void setFormName(String formName) {
		this.formName = formName;
	}

	/**
	 * 代码包名
	 */
	@Column(name = "package_name", length = 100)
	private String packageName;

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	/**
	 * 表单路径
	 */
	@Column(name = "form_path", length = 100)
	private String formPath;

	public String getFormPath() {
		return formPath;
	}

	public void setFormPath(String formPath) {
		this.formPath = formPath;
	}
	/**
	 * 数据保存模式
	 * 数据保存模式：1、正常 （数据实体）2、存储过程（2:过程名称）
	 */
	@Column(name = "save_mode", length = 32)
	private String saveMode;
	
	

	public String getSaveMode() {
		return saveMode;
	}

	public void setSaveMode(String saveMode) {
		this.saveMode = saveMode;
	}

	@Column(name = "published", length = 10)
	public Integer published;

	public Integer getPublished() {
		return published;
	}

	public void setPublished(Integer published) {
		this.published = published;
	}
	/**
	 * 模板内容clob
	 */
//	@Column(name = "template", length = 5000)
//	private String template;

	/**
	 * 模板html clob
	 */
//	@Column(name = "html", length = 5000)
//	private String html;

	/**
	 * 模板数据
	 */
	//@Column(name = "data", length = 5000)
//	private String data;

	//private Integer fields;// int ,

	/**
	 * 模板名称
	 */
	//@Column(name = "parse", length = 5000)
	//private String parse;

	/**
	 * JOSN数据
	 */
	@Column(name = "json", length = 100000)
	private String json;

	
	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

	// 表单属性
	@Transient
	public List<FormAttribute> formAttributeList;
	
	// 表单检索SQL属性
	@Transient
	public List<FormSearchSql> formSearchSqlList;
	

	/**
	 * 表单按钮显示名称（多个按钮以逗号分隔）
	 */
	// @Column(name="formbuttons_name",length=3000)
	// private String formbuttonsName;

	/**
	 * 表单按钮方法名称（多个按钮以逗号分隔）
	 */
	// @Column(name="formbuttons_method_name",length=3000)
	// private String formbuttonsMethodName;

	public List<FormAttribute> getFormAttributeList() {
		return formAttributeList;
	}

	public void setFormAttributeList(List<FormAttribute> formAttributeList) {
		this.formAttributeList = formAttributeList;
	}

	public List<FormSearchSql> getFormSearchSqlList() {
		return formSearchSqlList;
	}

	public void setFormSearchSqlList(List<FormSearchSql> formSearchSqlList) {
		this.formSearchSqlList = formSearchSqlList;
	}

	/**
	 * 页面每行显示的标签数
	 */
	@Column(name = "pagedatail_cols", length = 22)
	private Integer pagedatailCols;

	public Integer getPagedatailCols() {
		return pagedatailCols;
	}

	public void setPagedatailCols(Integer pagedatailCols) {
		this.pagedatailCols = pagedatailCols;
	}

	/**
	 * 页面Label标签占列数
	 */
	@Column(name = "label_cols", length = 22)
	private Integer labelCols;

	public Integer getLabelCols() {
		return labelCols;
	}

	public void setLabelCols(Integer labelCols) {
		this.labelCols = labelCols;
	}

	/**
	 * 页面Field标签占列数
	 */
	@Column(name = "field_cols", length = 22)
	private Integer fieldCols;

	public Integer getFieldCols() {
		return fieldCols;
	}

	public void setFieldCols(Integer fieldCols) {
		this.fieldCols = fieldCols;
	}

	/**
	 * 页面textArea显示的行数
	 */
	@Column(name = "textarea_rows", length = 22)
	private Integer textareaRows;

	public Integer getTextareaRows() {
		return textareaRows;
	}

	public void setTextareaRows(Integer textareaRows) {
		this.textareaRows = textareaRows;
	}

	/**
	 * 页面是否有附件
	 */
	@Column(name = "exist_attachment", length = 22)
	private Integer existAttachment;

	public Integer getExistAttachment() {
		return existAttachment;
	}

	public void setExistAttachment(Integer existAttachment) {
		this.existAttachment = existAttachment;
	}

	

	// ***********UeFrom*********************
	/*public static SafFormslist praseTemplate(SafFormslist form, String template) {

		if (form == null) {
			form = new SafFormslist();
		}

		String preg = "(\\|-<span(((?!<span).)*leipiplugins=\"(radios|checkboxs|select)\".*?)>(.*?)<\\/span>-\\||<(img|input|textarea|select).*?(<\\/select>|<\\/textarea>|\\/>))";

		String _html = template.replace("{|-", "").replace("-|}", "");
		String _parse = _html;

		// template=template.replace("单选框","");
		// template=template.replace("复选框","");
		template = template.replace("<a class=\"btn btn-link\">", "");
		template = template.replace("</a>", "");
		List<FormField> fs = new ArrayList<>();

		// 拼装表单内容
		// String
		// showfieldsEn="",showfieldsCh="",showfieldsType="",fieldTags="",validatorType="";

		List<String> fieldsEnList = new ArrayList<String>();
		List<String> fieldsChList = new ArrayList<String>();
		List<String> fieldTagsList = new ArrayList<String>();
		List<String> mustInputList = new ArrayList<String>();
		List<String> validatorList = new ArrayList<String>();
		List<String> sequenceList = new ArrayList<String>();
		List<String> dataSourceTypeList = new ArrayList<String>();
		List<String> dataSourceList = new ArrayList<String>();

		String separator = ",";
		String[] ms = Utils.maches(template, preg);
		FormField ff = null;

		List<FormAttribute> formAttributeList = new ArrayList<FormAttribute>();
		List<FormSearchSql> formSearchSqlList = new ArrayList<FormSearchSql>();
		
		FormAttribute formAttribute = null;
		int sequence = 0;
		for (String m : ms) {
			sequence++;
			formAttribute = new FormAttribute();
			ff = FormField.parseText(m);
			fs.add(ff);

			fieldsEnList.add(ff.getName());
			fieldsChList.add(ff.getTitle());
			fieldTagsList.add(ff.getLeipiplugins());
			mustInputList.add(ff.getNotnull() != null ? ff.getNotnull() : "0");
			
			formAttribute.setFormId(form.getId());
			formAttribute.setAttrName(ff.getTitle());
			formAttribute.setAttrCode(ff.getName());
			formAttribute.setDataFormat("string");
			formAttribute.setFieldTag(ff.getLeipiplugins());
			formAttribute.setMustInput(ff.getNotnull() != null ? Integer
					.parseInt(ff.getNotnull()) : 0);

			if ("text".equals(ff.getType())) {
				Text tx = ((Text) fs.get(fs.size() - 1));
				validatorList.add(tx.getOrgtype());
				formAttribute.setDataFormat(tx.getOrgtype());
			} else {
				validatorList.add("");
			}
			if ("select".equals(ff.getLeipiplugins())) {
				Select sel = ((Select) fs.get(fs.size() - 1));
				List<SelectOption> sellist = sel.getOptions();
				List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
				Map<String, Object> map = null;
				if ("mine".equals(sel.getValue_type())){ 
				  for (SelectOption option : sellist) {
					map = new HashMap<String, Object>();
					map.put(option.getValue(), option.getTitle());
				  	list.add(map);
				  }
				  // JSONObject json = new JSONObject();
				  String json = JSON.toJSON(list).toString();
			
					formAttribute.setDataSourceType("4");
					formAttribute.setDataSource(json);
					dataSourceTypeList.add("4");   //2 集合  3 数据字典  4  Json 
					dataSourceList.add(json);
				} else {
					formAttribute.setDataSourceType("2");
					formAttribute.setDataSource(sel.getUrl());  //记录的检索SQL 名称
					dataSourceTypeList.add("2");   //2 集合  3 数据字典  4  Json 
					dataSourceList.add(sel.getUrl());
					
					//保存到检索SQL表中
					FormSearchSql searchSql=new FormSearchSql();
					searchSql.setTargetField(ff.getName());
					searchSql.setSearchName(sel.getUrl());
					searchSql.setFormNo(form.getFormNo());
					formSearchSqlList.add(searchSql);
				}
			} else {
				dataSourceTypeList.add("");
				dataSourceList.add("");
			}

			sequenceList.add(Integer.toString(sequence));

			if (ff.getLeipiplugins().equals("listctrl")
					|| ff.getLeipiplugins().equals("select")
					|| ff.getLeipiplugins().equals("datepicker")
					|| ff.getLeipiplugins().equals("radios")
					|| ff.getLeipiplugins().equals("checkboxs")) {
				// 要替换listctrl
				String content = ff.getEdit(ff.getValue());
				_html = _html.replace(ff.getContent(), content);

			}
			String _f_parse = ff.getView(ff.getValue());
			if (_f_parse != null)
				_parse = _parse.replace(ff.getContent(), _f_parse);

			formAttributeList.add(formAttribute);
		}

		// 去掉 将各种属性 保存在saf_Form_Attribute中

		// form.setShowfieldsEn(listToString(fieldsEnList,separator));
		// form.setShowfieldsCh(listToString(fieldsChList,separator));
		// form.setFieldTag(listToString(fieldTagsList,separator));
		// form.setMustinputField(listToString(mustInputList,separator));

		// form.setDataSourceType(listToString(dataSourceTypeList,separator));
		// form.setDataSource(listToString(dataSourceList,separator));

		// form.setShowfieldsType(showfieldsType);
		form.setFormPath(form.getFormNo());
		form.setPackageName(form.getFormNo());

		// form.setValidatorType(listToString(validatorList,separator));
		// form.setSequence(listToString(sequenceList,separator));

		// ****************************************
		form.setForm_fields(fs);
		form.setData(JSON.toJSONString(fs));
		form.setFields(fs.size());
		form.setParse(_parse);
		form.setTemplate(template);
		form.setHtml(_html);

		form.setFormAttributeList(formAttributeList);
		form.setFormSearchSqlList(formSearchSqlList);
		return form;
	}
	*/

	// 数据拼装
	public static List assembleData(List<String> list, FormField formfield) {
		// *******************
		// if (!"".equals(showfieldsEn)){
		// showfieldsEn+=",";
		// }
		list.add(formfield.getName());

		/*
		 * showfieldsEn+=ff.getName(); if (!"".equals(showfieldsCh)){
		 * showfieldsCh+=","; } showfieldsCh+=ff.getTitle();
		 * 
		 * if (!"".equals(fieldTags)){ fieldTags+=","; } if
		 * ("text".equals(ff.getLeipiplugins())){ fieldTags+="input"; } if
		 * ("select".equals(ff.getLeipiplugins())){ fieldTags+="select"; }
		 * 
		 * if (!"".equals(showfieldsType)){ showfieldsType+=","; }
		 */
		// -------------------------------------
		return list;
	}

	// List转为字符串
	public static String listToString(List<String> list, String separator) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < list.size(); i++) {
			sb.append(list.get(i));
			if (i < list.size() - 1) {
				sb.append(separator);
			}
		}
		return sb.toString();
	}

/*	public String getEdit(String value) {

		String _temp = getTemplate().replace("{|-", "").replace("-|}", "");
		if (value == null)
			return _temp;

		JSONObject jsonObjet = JSON.parseObject(value);

		List<FormField> ffs = getForm_fields();
		for (FormField ff : ffs) {

			String ff_value = jsonObjet.getString(ff.getName());

			String ff_view = ff.getEdit(ff_value);

			_temp = _temp.replace(ff.getContent(), ff_view);

		}

		return _temp;
	}
*/
	/**
	 * 视图页面展示
	 * 
	 * @param value
	 *            后台保存的当前form的值 json
	 * @return 页面html代码
	 */
	/*public String getView(String value) {

		if (value == null)
			return getParse();

		String _temp = getTemplate().replace("{|-", "").replace("-|}", "");

		JSONObject jsonObjet = JSON.parseObject(value);

		List<FormField> ffs = getForm_fields();
		for (FormField ff : ffs) {

			String ff_value = jsonObjet.getString(ff.getName());

			String ff_view = ff.getView(ff_value);

			_temp = _temp.replace(ff.getContent(), ff_view);

		}

		return _temp;
	}

	@Transient
	private List<FormField> form_fields;

	public void setForm_fields(List<FormField> form_fields) {
		this.form_fields = form_fields;
	}
*/
	/*public List<FormField> getForm_fields() {

		if (data != null && (form_fields == null)) {
			List<FormField> list = JSON.parseArray(data, FormField.class);
			form_fields = new ArrayList<>();
			for (FormField ff : list) {
				ff = FormField.parseText(ff.getContent());
				form_fields.add(ff);
			}
		}

		return form_fields;
	}*/
}
