package com.huigou.uasp.form.domain.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Table;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;

@Entity
@EntityListeners({CreatorAndModifierListener.class})
public class PropertyDefines extends AbstractEntity implements Comparable<PropertyDefines>{
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 * 字段名
	 */
	@Column(name = "column_name")
	private String columnName;
	
	/**
	 * 
	 * 字段类型
	 */
	@Column(name = "data_type")
	private String dataType;
	/**
	 * 
	 * 长度
	 */
	@Column(name = "data_length")
	private String dataLength;
	/**
	 * 
	 * 注释
	 */
	@Column(name = "comments")
	private String comments;
	/**
	 * 
	 * 列序好
	 */
	@Column(name = "column_id")
	private String columnId;
	/**
	 * 
	 * 是否必填
	 */
	@Column(name = "nullable")
	private String nullable;
		
	private String yesorno;
	
	private String listdisplayField;
	
	private String listdisplayType;
	
	private String listdisplayFieldName;
	
	private String xmControlType;
	
	private String fieldTag;
	
	private String validatorType;
	
	private String dataSourceType;
	
	private String dataSource;
	
	private String listdisplaySearchField;

	private String sequence;
	
	public String getColumnName() {
		return columnName;
	}
	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}
	public String getDataType() {
		return dataType;
	}
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	public String getDataLength() {
		return dataLength;
	}
	public void setDataLength(String dataLength) {
		this.dataLength = dataLength;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getColumnId() {
		return columnId;
	}
	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}
	public String getNullable() {
		return nullable;
	}
	public void setNullable(String nullable) {
		this.nullable = nullable;
	}
	public String getYesorno() {
		return yesorno;
	}
	public void setYesorno(String yesorno) {
		this.yesorno = yesorno;
	}
	public String getListdisplayField() {
		return listdisplayField;
	}
	public void setListdisplayField(String listdisplayField) {
		this.listdisplayField = listdisplayField;
	}
	public String getXmControlType() {
		return xmControlType;
	}
	public void setXmControlType(String xmControlType) {
		this.xmControlType = xmControlType;
	}
	public String getValidatorType() {
		return validatorType;
	}
	public void setValidatorType(String validatorType) {
		this.validatorType = validatorType;
	}
	
	public String getFieldTag() {
		return fieldTag;
	}
	public void setFieldTag(String fieldTag) {
		this.fieldTag = fieldTag;
	}
	public String getDataSourceType() {
		return dataSourceType;
	}
	public void setDataSourceType(String dataSourceType) {
		this.dataSourceType = dataSourceType;
	}
	public String getDataSource() {
		return dataSource;
	}
	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}
	public String getSequence() {
		return sequence;
	}
	public void setSequence(String sequence) {
		this.sequence = sequence;
	}
	public String getListdisplayFieldName() {
		return listdisplayFieldName;
	}
	public void setListdisplayFieldName(String listdisplayFieldName) {
		this.listdisplayFieldName = listdisplayFieldName;
	}
		
	public String getListdisplayType() {
		return listdisplayType;
	}
	public void setListdisplayType(String listdisplayType) {
		this.listdisplayType = listdisplayType;
	}
	
	
	
	 public String getListdisplaySearchField() {
		return listdisplaySearchField;
	}
	public void setListdisplaySearchField(String listdisplaySearchField) {
		this.listdisplaySearchField = listdisplaySearchField;
	}
	@Override
	  public int compareTo(PropertyDefines s) {

	         if(Integer.parseInt(!"".equals(this.sequence)?this.sequence:"0") >= Integer.parseInt((!"".equals(s.getSequence())?s.getSequence():"0"))){
	              return 1;
	          }
	          return -1;
	    
	  }
	
	
}
