package com.huigou.uasp.form.domain.model;


import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.huigou.data.domain.model.AbstractEntity;
;

@Entity
@Table(name = "SAF_FORM_SEARCH_SQL")
public class FormSearchSql extends AbstractEntity {
	private static final long serialVersionUID = 1L;
	/**
	 * 表名
	 */
	@Column(name = "table_name", length = 128)
	private String tableName;

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	/**
	 * xml中搜索名称
	 */
	@Column(name = "search_name", length = 32)
	private String searchName;

	public String getSearchName() {
		return searchName;
	}

	public void setSearchName(String searchName) {
		this.searchName = searchName;
	}

	/**
	 * xml中搜索名称描述
	 */
	@Column(name = "search_desc", length = 100)
	private String searchDesc;

	public String getSearchDesc() {
		return searchDesc;
	}

	public void setSearchDesc(String searchDesc) {
		this.searchDesc = searchDesc;
	}

	/**
	 * easy_search的xml文件名称
	 */
	@Column(name = "searchbox_type", length = 32)
	private String searchboxType;

	public String getSearchboxType() {
		return searchboxType;
	}

	public void setSearchboxType(String searchboxType) {
		this.searchboxType = searchboxType;
	}

	/**
	 * 目标业务字段
	 */
	@Column(name = "target_field", length = 32)
	private String targetField;

	public String getTargetField() {
		return targetField;
	}

	public void setTargetField(String targetField) {
		this.targetField = targetField;
	}

	/**
	 * 显示字段名称（多个以逗号分隔）
	 */
	@Column(name = "field_names", length = 1000)
	private String fieldNames;

	public String getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(String fieldNames) {
		this.fieldNames = fieldNames;
	}

	/**
	 * 显示字段code（多个以逗号分隔）
	 */
	@Column(name = "field_codes", length = 1000)
	private String fieldCodes;

	public String getFieldCodes() {
		return fieldCodes;
	}

	public void setFieldCodes(String fieldCodes) {
		this.fieldCodes = fieldCodes;
	}

	/**
	 * 显示字段类型
	 */
	@Column(name = "field_types", length = 1000)
	private String fieldTypes;

	public String getFieldTypes() {
		return fieldTypes;
	}

	public void setFieldTypes(String fieldTypes) {
		this.fieldTypes = fieldTypes;
	}

	/**
	 * 显示字段宽度
	 */
	@Column(name = "field_widths", length = 1000)
	private String fieldWidths;

	public String getFieldWidths() {
		return fieldWidths;
	}

	public void setFieldWidths(String fieldWidths) {
		this.fieldWidths = fieldWidths;
	}

	/**
	 * 列表框搜索条件字段（多个以逗号分隔）
	 */
	@Column(name = "condi_columns", length = 1000)
	private String condiColumns;

	public String getCondiColumns() {
		return condiColumns;
	}

	public void setCondiColumns(String condiColumns) {
		this.condiColumns = condiColumns;
	}

	/**
	 * 列表框搜索条件名称
	 */
	@Column(name = "condi_names", length = 1000)
	private String condiNames;

	public String getCondiNames() {
		return condiNames;
	}

	public void setCondiNames(String condiNames) {
		this.condiNames = condiNames;
	}

	/**
	 * 列表框搜索条件字段类型
	 */
	@Column(name = "condi_types", length = 1000)
	private String condiTypes;

	public String getCondiTypes() {
		return condiTypes;
	}

	public void setCondiTypes(String condiTypes) {
		this.condiTypes = condiTypes;
	}

	/**
	 * 列表框搜索条件匹配类型
	 */
	@Column(name = "condi_symbols", length = 1000)
	private String condiSymbols;

	public String getCondiSymbols() {
		return condiSymbols;
	}

	public void setCondiSymbols(String condiSymbols) {
		this.condiSymbols = condiSymbols;
	}

	/**
	 * 搜索条件表别名
	 */
	@Column(name = "condi_alias", length = 1000)
	private String condiAlias;

	public String getCondiAlias() {
		return condiAlias;
	}

	public void setCondiAlias(String condiAlias) {
		this.condiAlias = condiAlias;
	}

	/**
	 * 排序字段
	 */
	@Column(name = "orderby", length = 1000)
	private String orderby;

	public String getOrderby() {
		return orderby;
	}

	public void setOrderby(String orderby) {
		this.orderby = orderby;
	}

	/**
	 * 查询的sql语句
	 */
	@Column(name = "search_sql", length = 1000)
	private String searchSql;

	public String getSearchSql() {
		return searchSql;
	}

	public void setSearchSql(String searchSql) {
		this.searchSql = searchSql;
	}

	/**
	 * 页面接收字段
	 */
	@Column(name = "back_fields", length = 1000)
	private String backFields;

	public String getBackFields() {
		return backFields;
	}

	public void setBackFields(String backFields) {
		this.backFields = backFields;
	}

	/*
	 * SQL中指定参数名称（以冒号开头的）
	 */
	@Column(name = "param_fields", length = 1000)
	private String paramFields;

	public String getParamFields() {
		return paramFields;
	}

	public void setParamFields(String paramFields) {
		this.paramFields = paramFields;
	}

	/*
	 * SQL中指定参数的对应来源字段
	 */
	@Column(name = "param_source_fields", length = 1000)
	private String paramSourceFields;

	public String getParamSourceFields() {
		return paramSourceFields;
	}

	public void setParamSourceFields(String paramSourceFields) {
		this.paramSourceFields = paramSourceFields;
	}
	  /**
     * 创建时间
     */
    @Column(name = "created_date", length = 20)
    private Date  createdDate;

    
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	/*
	 * SQL中指定参数的对应来源表
	 */
	@Column(name = "param_source_tables", length = 1000)
	private String paramSourceTables;
	
	
	public String getParamSourceTables() {
		return paramSourceTables;
	}

	public void setParamSourceTables(String paramSourceTables) {
		this.paramSourceTables = paramSourceTables;
	}

	@Column(name = "form_no", length = 100)
	private String formNo;

	public String getFormNo() {
		return formNo;
	}

	public void setFormNo(String formNo) {
		this.formNo = formNo;
	}
	@Column(name = "content", length = 3000)
	private String content;

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	
	
}
