package com.huigou.uasp.form.domain.model;

import java.util.Date;
import java.lang.Double;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;

import javax.persistence.*;


@Entity
@Table(name = "SAF_FORM_PARAMETER")
@EntityListeners({CreatorAndModifierListener.class})
public class FormParameter extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    /**
     * FormId
     */
    @Column(name = "FORM_NO", length = 100)
    private String formNo;

   
    /**
     * 参数类型
     */
    @Column(name = "parm_type", length = 10)
    private Integer parmType;

    
    /**
     * 参数Name
     */
    @Column(name = "parm_name", length = 100)
    private String parmName;
    

    /**
     * 参数Code
     */
    @Column(name = "parm_code", length = 100)
    private String parmCode;
    
    
    /**
     * 参数Code
     */
    @Column(name = "parm_vals", length = 3000)
    private String parmVals;
    
    /**
     * 状态1启用、停用0
     */
    @Column(name = "status", length =10)
    private Integer status;

    /**
     * 备注
     */
    @Column(name = "remark", length = 1000)
    private String remark;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

	

	public String getFormNo() {
		return formNo;
	}

	public void setFormNo(String formNo) {
		this.formNo = formNo;
	}

	public Integer getParmType() {
		return parmType;
	}

	public void setParmType(Integer parmType) {
		this.parmType = parmType;
	}

	public String getParmName() {
		return parmName;
	}

	public void setParmName(String parmName) {
		this.parmName = parmName;
	}

	public String getParmCode() {
		return parmCode;
	}

	public void setParmCode(String parmCode) {
		this.parmCode = parmCode;
	}

	public String getParmVals() {
		return parmVals;
	}

	public void setParmVals(String parmVals) {
		this.parmVals = parmVals;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
    
   
    
	
}
