package com.huigou.uasp.form.domain.model;

import java.util.Date;
import java.lang.Double;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;

import javax.persistence.*;


@Entity
@Table(name = "SAF_FORM_BUTTONS")
@EntityListeners({CreatorAndModifierListener.class})
public class FormButtons extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    /**
     * FormId
     */
    @Column(name = "form_id", length = 32)
    private String formId;

   
    /**
     * 按钮名称
     */
    @Column(name = "button_name", length = 100)
    private String buttonName;

    /**
     * 按钮方法名称
     */
    @Column(name = "button_method_name", length = 100)
    private String buttonMethodName;
    
    
    /**
     * 按钮方法内容 
     */
    @Column(name = "button_method_content", length = 1000)
    private String buttonMethodContent;
    
    
    @Column(name = "button_type", length = 10)
    private Integer buttonType;
    
    
    @Column(name = "button_key", length = 100)
    private String buttonKey;
    
    @Column(name = "sequence", length = 10)
    private Integer sequence;
    
    
    @Column(name = "remark", length = 1000)
    private String remark;
    
    /**
     * 状态1启用、停用0
     */
    @Column(name = "status", length = 22)
    private Integer status;

	public String getFormId() {
		return formId;
	}

	public void setFormId(String formId) {
		this.formId = formId;
	}

	public String getButtonName() {
		return buttonName;
	}

	public void setButtonName(String buttonName) {
		this.buttonName = buttonName;
	}

	public String getButtonMethodName() {
		return buttonMethodName;
	}

	public void setButtonMethodName(String buttonMethodName) {
		this.buttonMethodName = buttonMethodName;
	}

	public String getButtonMethodContent() {
		return buttonMethodContent;
	}

	public void setButtonMethodContent(String buttonMethodContent) {
		this.buttonMethodContent = buttonMethodContent;
	}

	public Integer getButtonType() {
		return buttonType;
	}

	public void setButtonType(Integer buttonType) {
		this.buttonType = buttonType;
	}

	public String getButtonKey() {
		return buttonKey;
	}

	public void setButtonKey(String buttonKey) {
		this.buttonKey = buttonKey;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}
    
   
	
}
