package com.huigou.uasp.form.domain.model;

import java.util.Date;
import java.lang.Double;

import com.huigou.data.domain.listener.CreatorAndModifierListener;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.Creator;

import javax.persistence.*;


@Entity
@Table(name = "SAF_FORM_ATTRIBUTE")
@EntityListeners({CreatorAndModifierListener.class})
public class FormAttribute extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    /**
     * FormId
     */
    @Column(name = "form_id", length = 32)
    private String formId;

   
    /**
     * 属性名称
     */
    @Column(name = "meta_id", length = 100)
    private String metaId;

    
    /**
     * 属性Name
     */
    @Column(name = "attr_name", length = 100)
    private String attrName;
    

    /**
     * 属性CODE
     */
    @Column(name = "attr_code", length = 100)
    private String attrCode;

    public String getAttrCode() {
        return attrCode;
    }

    public void setAttrCode(String attrCode) {
        this.attrCode = attrCode;
    }

   	/**
     * 备注
     */
    @Column(name = "remark", length = 1000)
    private String remark;
    
    
 	/**
     * 样式
     */
    @Column(name = "css_style", length = 1000)
    private String cssStyle;


    /**
     * 效验DB函数及其参数   
     * DB效验函数或过程(冒号后面是参数字段和返回字段,参数字段逗号分隔, 参数字段和返回字段中主表字段使用[]括起来)
     */
    @Column(name = "check_function", length = 500)
    private String checkFunction;
    
    /**
     * JS效验函数
     * js中如果是获取主表字段的值  使用  "#[name]"格式 
     * 如果是明细表格中js中调用的明细表字段是以grid.record.开头获取   否则不予解析和转换
     * 明细表中更新值的写法XXXGridManager.updateCell('name','',grid.record)
     *                   获取明细表的列： grid.column.name
     */
    @Column(name = "js_function", length = 1000)
    private String jsFunction;
    
    
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
    /**
     * 下拉框的数据来源类型
     */
    @Column(name = "data_source_type", length = 10)
    private String dataSourceType;

    
    /**
     * 下拉框的数据来源
     */
    @Column(name = "data_source", length = 1000)
    private String dataSource;

    

    /**
     * 是否必输(是1否0)
     */
    @Column(name = "must_input", length = 22)
    private Integer mustInput;

    public Integer getMustInput() {
        return mustInput;
    }

    public void setMustInput(Integer mustInput) {
        this.mustInput = mustInput;
    }

    /**
     * 默认值
     */
    @Column(name = "default_value", length = 200)
    private String defaultValue;

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * 字段类型
     * 数据格式(字符string、数值number、金额money、电话phone）
     */
    @Column(name = "data_format", length = 50)
    private String dataFormat;

    public String getDataFormat() {
        return dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    /**
     * 显示控件类型（文本框、选择框、日期框、多行文本框、单选框、复选框等）
     */
    @Column(name = "field_tag", length = 50)
    private String fieldTag;

    public String getFieldTag() {
        return fieldTag;
    }

    public void setFieldTag(String fieldTag) {
        this.fieldTag = fieldTag;
    }

    /**
     * 是否在列表框中显示(1表示是 0为否)
     */
    @Column(name = "display_listing", length = 22)
    private Integer displayListing;

    public Integer getDisplayListing() {
        return displayListing;
    }

    public void setDisplayListing(Integer displayListing) {
        this.displayListing = displayListing;
    }

    /**
     * 表类型(1、主表，2、明细表)
     */
    @Column(name = "table_type", length = 10)
    private Integer tableType;

    

    public Integer getTableType() {
		return tableType;
	}

	public void setTableType(Integer tableType) {
		this.tableType = tableType;
	}

	/**
     * 表名称
     */
    @Column(name = "table_name", length = 40)
    private String  tableName;

  

    public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	/**
     * 是否唯一字段（1为是）
     */
    @Column(name = "max_length", length = 10)
    private Integer maxLength;

       
    public Integer getMaxLength() {
		return maxLength;
	}

	public void setMaxLength(Integer maxLength) {
		this.maxLength = maxLength;
	}

	/**
     * 是否搜索标签(1为是）
     */
    @Column(name = "search_field", length = 22)
    private Integer searchField;

    public Integer getSearchField() {
        return searchField;
    }

    public void setSearchField(Integer searchField) {
        this.searchField = searchField;
    }

    /**
     * 显示顺序号
     */
    @Column(name = "sequence", length = 22)
    private Integer sequence;

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    /**
     * 状态1启用、停用0
     */
    @Column(name = "status", length = 22)
    private Integer status;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

  

    /**
     * 只读/读写/无权限
     */
    @Column(name = "default_operation", length =10)
    private String defaultOperation;

    
    /**
     * 表名称
     */
    @Column(name = "created_date", length = 20)
    private Date  createdDate;

    
    public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Transient
    private String isOld;

    public String getIsOld() {
        return isOld;
    }

    public void setIsOld(String isOld) {
        this.isOld = isOld;
    }


    public String getDefaultOperation() {
        return defaultOperation;
    }

    public void setDefaultOperation(String defaultOperation) {
        this.defaultOperation = defaultOperation;
    }

    public String getFormId() {
		return formId;
	}

	public void setFormId(String formId) {
		this.formId = formId;
	}

	public String getMetaId() {
		return metaId;
	}

	public void setMetaId(String metaId) {
		this.metaId = metaId;
	}

	

	public String getAttrName() {
		return attrName;
	}

	public void setAttrName(String attrName) {
		this.attrName = attrName;
	}


	public String getDataSourceType() {
		return dataSourceType;
	}

	public void setDataSourceType(String dataSourceType) {
		this.dataSourceType = dataSourceType;
	}

	public String getDataSource() {
		return dataSource;
	}

	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}

	public String getCssStyle() {
		return cssStyle;
	}

	public void setCssStyle(String cssStyle) {
		this.cssStyle = cssStyle;
	}

	public String getCheckFunction() {
		return checkFunction;
	}

	public void setCheckFunction(String checkFunction) {
		this.checkFunction = checkFunction;
	}

	public String getJsFunction() {
		return jsFunction;
	}

	public void setJsFunction(String jsFunction) {
		this.jsFunction = jsFunction;
	}


    
	
}
