package com.huigou.uasp.form.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.alibaba.fastjson.JSONObject;
import com.huigou.cache.SystemCache;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.application.SafFormslistApplication;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.model.ResultModel;
import com.huigou.uasp.form.repository.FormAttributeRepository;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.util.SDO;


/**
 * 表单设计控制类
 * @author lxh
 *
 */
@Controller
public class FormInterController extends CommonController{ 

	
	@Autowired
	private  SafFormslistRepository safFormslistRepository;

	@Autowired
	private  FormTablesRepository formTablesRepository;

	@Autowired
	private  FormAttributeRepository formAttributeRepository;

	@Autowired
	private  CommonUtilApplication  commonUtilApplication; 

	@Autowired
	private SafFormslistApplication safFormsApplication;


	@Override
	protected String getPagePath(){
		return "/formdesign/resource/js/ueditor/formdesign/";
	}

	
	 //获取数据的
	 @SkipAuth
	 @RequestMapping(value = "/getdatas",method={RequestMethod.POST,RequestMethod.GET})//
	 public String getData(HttpServletRequest request, HttpServletResponse response){
		    JSONObject backData = new JSONObject();
		   Map <String, Object>map = new HashMap<String, Object>();
		   List <Map<String,Object>>list=new ArrayList<Map<String,Object>>();
		   
		        map.put("success", "1");
			    map.put("field", "name");
			    list.add(map);
			    
			    JSONObject json = new JSONObject();

						json.put("name", "name");
				    	json.put("sex", "sex");
				   	    json.put("key", "key");
	
				        json.put("sourceType", "WS");
				        json.put("adapterName", "OSendAdapter");
				        
				        Map <String, Object>mapjs = new HashMap<String, Object>();
				    
				     mapjs.put("to",json.toJSONString());
			         String datas= JSONObject.toJSON(mapjs).toString();
			         return toResult(datas);
			    
		   // renderData(response, backData.toJSONString());
	 }
			   	//输出数据
			   	protected void renderData(HttpServletResponse response, String data) {
			   	        PrintWriter printWriter = null;
			   	        try {
			   	            printWriter = response.getWriter();
			   	            printWriter.print(data);
			   	        } catch (IOException ex) {

			   	        } finally {
			   	            if (null != printWriter) {
			   	                printWriter.flush();
			   	                printWriter.close();
			   	            }
			   	        }
			   	    }
}
