package com.huigou.uasp.form.controller;

import com.alibaba.fastjson.JSON;
import com.huigou.cache.DictUtil;
import com.huigou.cache.SystemCache;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.application.FormsDesignApplication;
import com.huigou.uasp.form.application.SafFormslistApplication;
import com.huigou.uasp.form.domain.model.FormSearchSql;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.domain.query.FormsAttributeQueryRequest;
import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.form.pojo.Root;
import com.huigou.uasp.form.pojo.RootBean;
import com.huigou.uasp.form.pojo.TableColumns;
import com.huigou.uasp.form.pojo.analysis.PublicAnalysis;
import com.huigou.uasp.form.repository.FormAttributeRepository;
import com.huigou.uasp.form.repository.FormSearchSqlRepository;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.util.SDO;
import net.sf.ezmorph.bean.MorphDynaBean;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.DynaProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.*;

//import com.alibaba.fastjson.JSONObject;


/**
 * 表单设计控制类
 *
 * @author lxh
 */
@Controller
@ControllerMapping("formDesign")
public class FormDesignController extends CommonController {


    @Autowired
    private SafFormslistRepository safFormslistRepository;

    @Autowired
    private FormTablesRepository formTablesRepository;

    @Autowired
    private FormAttributeRepository formAttributeRepository;

    @Autowired
    private FormSearchSqlRepository formSearchSqlRepository;

    @Autowired
    private CommonUtilApplication commonUtilApplication;

    @Autowired
    private SafFormslistApplication safFormsApplication;

    @Autowired
    private FormsDesignApplication formsDesignApplication;

    @Override
    protected String getPagePath() {
        return "/formdesign/resource/js/ueditor/formdesign/";
    }

    //跳转到表单 标签页面
    public String forwardFormDesignPage() {
        SDO sdo = this.getSDO();
        String formNo = sdo.getString("formNo");
        String pageType = sdo.getString("pageType");
        List<SafFormslist> formList = safFormslistRepository.findByFormNo(formNo);
        SafFormslist form = formList.get(0);
        String tableName = commonUtilApplication.getTablesByFormId(form.getId(), 1);
        tableName = tableName.split(",")[0];  //取第一个主表
        //获取表字段元素
        List<Map<String, Object>> fieldLists = commonUtilApplication.queryFormTableFields(formNo, tableName);
        this.putAttribute("fieldLists", com.alibaba.fastjson.JSONObject.toJSON(fieldLists));
        return forward(pageType);
    }

    public String forwardFormMaking() {
        return forward("/formdesign/formMaking.jsp");
    }


    //保存表单元素设计  _旧的方式
/*	 public String  saveOrUpdateForm(){
	 	  SDO sdo = this.getSDO(); 
	 	   HttpServletRequest request = getRequest();
	 	  String template=request.getParameter("template");
	       ResultModel model = new ResultModel();
	 System.out.println("template:==="+template);
	 //System.out.println("parse_form : " + parse_form);
	      // template=sdo.getString("template");
	  if(template == null || template.trim().length() < 1) {
	 	  model.setMessage("请至少绘制一个元素");
	 	  return toResult(model);
	   }
	    String  formNo=sdo.getString("formNo");
	    SafFormslist form =null;
	    if (formNo!=null&&!"".equals(formNo)){
	       form=this.safFormslistRepository.findByFormNo(formNo).get(0);
	    } 
	       form = SafFormslist.praseTemplate(form,template);
	   
	    //form.setFormName(form_name);
	    //form.setTable_name(table_name);
	    //form.setFormId(formId);
	   
	   //String error = form.getFormId() != null && form.getFormId() > 0 ? ueService.updateForm(form) : ueService.addForm(form);
	       
	       safFormsApplication.saveOrUpdateForm(form);
	      
	   //if(error != null) {
	   	//model.setMessage(error);
	 	//return model ; 
	  //}
	   
	   //包含 template data parse  fields add_fields
	       model.putData("data", form);
	       return  toResult(model);
	 }
	 
	 */
    //*********************************************************************************************88


    //获取主表字段数据的接口

    /**
     * @param //:formno
     * @return
     */
    @RequestMapping(value = "/getmainfields", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getMainFields(HttpServletRequest request, HttpServletResponse response) {
        JSONObject backData = new JSONObject();
        // Map <String, Object>map = new HashMap<String, Object>();
        //  List <Map<String,Object>>list=new ArrayList<Map<String,Object>>();
        String formNo = request.getParameter("formno");
        Assert.hasText(formNo, "缺少参数formno");
        List<SafFormslist> formList = this.safFormslistRepository.findByFormNo(formNo);
        SafFormslist form = formList.get(0);
        String tableName = commonUtilApplication.getTablesByFormId(form.getId(), 1);
        tableName = tableName.split(",")[0];  //取第一个主表

        //获取主表字段元素
        List<Map<String, Object>> fieldLists = commonUtilApplication.queryFormTableFields(formNo, tableName);
        return toResult(fieldLists);
        // renderData(response, backData.toJSONString());
    }

    //获取表单所有表的接口

    /**
     * @param //:formno
     * @return
     */
    @RequestMapping(value = "/getalltables", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getAllTables(HttpServletRequest request, HttpServletResponse response) {
        JSONObject backData = new JSONObject();
        //  Map <String, Object>map = new HashMap<String, Object>();
        // List <Map<String,Object>>list=new ArrayList<Map<String,Object>>();
        String formNo = request.getParameter("formno");
        Assert.hasText(formNo, "缺少参数formno!");
        SafFormsQueryRequest queryRequest = new SafFormsQueryRequest();
        queryRequest.setFormNo(formNo);
        // List<SafFormslist> formList=this.safFormslistRepository.findByFormNo(formNo);
        // formList
        List<Map<String, Object>> tableList = this.safFormsApplication.queryExistTables(queryRequest);
        return toResult(tableList);
        // renderData(response, backData.toJSONString());
    }


    //获取明细表字段数据的接口

    /**
     * @param //formno,tablename
     * @return
     */
    @RequestMapping(value = "/getfields", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getFields(HttpServletRequest request, HttpServletResponse response) {
        JSONObject backData = new JSONObject();
        //  Map <String, Object>map = new HashMap<String, Object>();
        //  List <Map<String,Object>>list=new ArrayList<Map<String,Object>>();
        String formNo = request.getParameter("formno");
        Assert.hasText(formNo, "缺少参数formno");
        String tableName = request.getParameter("tablename");
        Assert.hasText(tableName, "缺少参数formno");
        //获取明细表字段元素
        List<Map<String, Object>> fieldLists = commonUtilApplication.queryFormTableFields(formNo, tableName);
        return toResult(fieldLists);
    }

    //获取检索SQL的接口

    /**
     * @param // formno
     * @return
     */
    @RequestMapping(value = "/getsearchsql", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getSearchSql(HttpServletRequest request, HttpServletResponse response) {
        String formNo = request.getParameter("formno");
        Assert.hasText(formNo, "缺少参数formno");
        List<FormSearchSql> sqllist = this.formSearchSqlRepository.searchSqlByFormNo(formNo);
        //获取明细表字段元素
        //List<Map<String, Object>> fieldLists=commonUtilApplication.queryFormTableFields(formNo,tableName);
        return toResult(sqllist);
    }

    //获取表单Json
    @RequestMapping(value = "/getformjson", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getTestData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject backData = new JSONObject();
        String formNo = request.getParameter("formno");
        Assert.hasText(formNo, "缺少参数formNo");
        //  datas="{\"list\":[{\"type\":\"table\",\"icon\":\"icon-table\",\"options\":{\"defaultValue\":[],\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"required\":false,\"remoteFunc\":\"func_1592183795541\",\"remoteOption\":\"option_1592183795541\"},\"tableColumns\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183804092\",\"remoteOption\":\"option_1592183804092\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"  预算编号\",\"novalid\":{},\"key\":\"1592183804092\",\"model\":\"input_1592183804092\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183830591\",\"remoteOption\":\"option_1592183830591\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"预算名称\",\"novalid\":{},\"key\":\"1592183830591\",\"model\":\"input_1592183830591\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183846416\",\"remoteOption\":\"option_1592183846416\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"数量\",\"novalid\":{},\"key\":\"1592183846416\",\"model\":\"input_1592183846416\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183862642\",\"remoteOption\":\"option_1592183862642\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"金额\",\"novalid\":{},\"key\":\"1592183862642\",\"model\":\"input_1592183862642\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183959895\",\"remoteOption\":\"option_1592183959895\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"规格型号\",\"novalid\":{},\"key\":\"1592183959895\",\"model\":\"规格型号\",\"rules\":[]}],\"name\":\"\",\"key\":\"1592183795541\",\"model\":\"table_1592183795541\",\"rules\":[]},{\"type\":\"grid\",\"icon\":\"icon-RectangleCopy\",\"columns\":[{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184027111\",\"remoteOption\":\"option_1592184027111\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"项目名称\",\"novalid\":{},\"key\":\"1592184027111\",\"model\":\"input_1592184027111\",\"rules\":[]},{\"type\":\"date\",\"icon\":\"icon-date\",\"options\":{\"defaultValue\":\"\",\"readonly\":false,\"disabled\":false,\"editable\":true,\"clearable\":true,\"placeholder\":\"\",\"startPlaceholder\":\"\",\"endPlaceholder\":\"\",\"type\":\"date\",\"format\":\"yyyy-MM-dd\",\"timestamp\":false,\"required\":false,\"requiredMessage\":\"\",\"width\":\"\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592184176333\",\"remoteOption\":\"option_1592184176333\"},\"event\":{\"change\":\"\"},\"name\":\"交付日期\",\"key\":\"1592185088088\",\"model\":\"date_1592184176333\",\"rules\":[],\"novalid\":{}},{\"type\":\"select\",\"icon\":\"icon-select\",\"options\":{\"defaultValue\":\"\",\"multiple\":false,\"disabled\":false,\"clearable\":false,\"placeholder\":\"\",\"required\":false,\"requiredMessage\":\"\",\"showLabel\":false,\"width\":\"\",\"options\":[{\"value\":\"Option 1\"},{\"value\":\"Option 2\"},{\"value\":\"Option 3\"}],\"remote\":false,\"remoteType\":\"dictionary\",\"dictionary\":\"\",\"filterable\":false,\"remoteOptions\":[],\"props\":{\"value\":\"value\",\"label\":\"label\"},\"list\":\"\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592184096187\",\"remoteOption\":\"option_1592184096187\"},\"event\":{\"change\":\"\"},\"name\":\"采购类型\",\"key\":\"1592184216605\",\"model\":\"select_1592184096187\",\"rules\":[],\"novalid\":{}}]},{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184045106\",\"remoteOption\":\"option_1592184045106\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"系统\",\"novalid\":{},\"key\":\"1592184045106\",\"model\":\"input_1592184045106\",\"rules\":[]}]}],\"options\":{\"gutter\":0,\"justify\":\"start\",\"align\":\"top\",\"customClass\":\"\",\"hidden\":false,\"flex\":true,\"responsive\":false,\"remoteFunc\":\"func_1592184014765\",\"remoteOption\":\"option_1592184014765\"},\"name\":\"栅格布局\",\"key\":\"1592184014765\",\"model\":\"grid_1592184014765\",\"rules\":[]}],\"config\":{\"labelWidth\":100,\"labelPosition\":\"right\",\"size\":\"small\",\"customClass\":\"\",\"ui\":\"element\",\"layout\":\"horizontal\",\"labelCol\":3,\"width\":\"100%\"}}";
        List<SafFormslist> formList = this.safFormslistRepository.findByFormNo(formNo);
        Assert.notEmpty(formList, "表单编号" + formNo + "不存在!");
        Object json = formList.stream()
                .findAny()
                .map(SafFormslist::getJson)
                .map(JSON::parse)
                .orElse(Collections.emptyMap());
        return toResult(json);
    }

    //获取数据字典接口
    @RequestMapping(value = "/getdatadict", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getDataDict(HttpServletRequest request, HttpServletResponse response) {
        String dictFolderName = SystemCache.getParameter("formDictFolderName", String.class);
        List<Map<String, Object>> datalist = this.formsDesignApplication.getFormDataDict(dictFolderName);
        return toResult(datalist);
    }

    //获取DB函数或过程的接口
    /*
     * para:type=f 函数  = p 表示过程
     */
    @RequestMapping(value = "/getdbobject", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getDBFunctions(HttpServletRequest request, HttpServletResponse response) {
        // JSONObject backData = new JSONObject();
        // String formNo=request.getParameter("formno");
        String datas = "";
        String type = request.getParameter("type");
        if ("func".equals(type)) {
            type = "FUNCTION";
        } else if ("proc".equals(type)) {
            type = "PROCEDURE";
        } else {

        }
        List<Map<String, Object>> datalist = this.formsDesignApplication.getDBFunctionsOrProceduce(type);
        return toResult(datalist);
    }

    //获取字段类型接口
    @RequestMapping(value = "/getfieldtype", method = {RequestMethod.POST, RequestMethod.GET})//
    public String getFieldType(HttpServletRequest request, HttpServletResponse response) {
        // JSONObject backData = new JSONObject();
        // String formNo=request.getParameter("formno");
        // String dictFolderName = SystemCache.getParameter("formDictFolderName", String.class);
        List<Map<String, Object>> datalist = DictUtil.getDictionaryList("validatorType");
        return toResult(datalist);
    }


    //保存数据的接口
    @RequestMapping(value = "/saveform", method = {RequestMethod.POST, RequestMethod.GET})//
    public String saveFormData(HttpServletRequest request, HttpServletResponse response) {
        JSONObject backData = new JSONObject();
        Map<String, Object> map = new HashMap<String, Object>();
        //List <Map<String,Object>>list=new ArrayList<Map<String,Object>>();
        String formNo = request.getParameter("formno");
        String contents = request.getParameter("datas");
        String datas = "";
        try {
            //  contents=URLDecoder.decode(contents, "UTF-8");

            System.out.println(formNo + "==========" + contents);
            PrintWriter out = response.getWriter();
            if (formNo == null) {
                datas = "缺少参数formNo!";
                backData.put("reason", datas);
                out.println(backData.toString());
                out.close();
            } else {
                if (contents == null) {
                    datas = "缺少参数datas!";
                    backData.put("reason", datas);
                    //  out.println(backData.toString());
                    // out.close();
                    //测试数据
                    // contents="{\"list\":[{\"type\":\"table\",\"tablename\":\"SMS_ORDER_DETAIL\",\"icon\":\"icon-table\",\"options\":{\"defaultValue\":[],\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"required\":false,\"remoteFunc\":\"func_1592183795541\",\"remoteOption\":\"option_1592183795541\"},\"tableColumns\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183804092\",\"remoteOption\":\"option_1592183804092\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"订单编号\",\"novalid\":{},\"key\":\"1592183804092\",\"model\":\"order_num\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183830591\",\"remoteOption\":\"option_1592183830591\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"名称\",\"novalid\":{},\"key\":\"1592183830591\",\"model\":\"name\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183846416\",\"remoteOption\":\"option_1592183846416\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"联系人\",\"novalid\":{},\"key\":\"1592183846416\",\"model\":\"linkman\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183862642\",\"remoteOption\":\"option_1592183862642\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"单价\",\"novalid\":{},\"key\":\"1592183862642\",\"model\":\"unit_price\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"date\",\"icon\":\"icon-date\",\"options\":{\"defaultValue\":\"\",\"readonly\":false,\"disabled\":false,\"editable\":true,\"clearable\":true,\"placeholder\":\"\",\"startPlaceholder\":\"\",\"endPlaceholder\":\"\",\"type\":\"date\",\"format\":\"yyyy-MM-dd\",\"timestamp\":false,\"required\":false,\"requiredMessage\":\"\",\"width\":\"200px\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592793103693\",\"remoteOption\":\"option_1592793103693\",\"tableColumn\":true},\"table\":\"SMS_ORDER_DETAIL\",\"event\":{\"change\":\"\"},\"name\":\"日期\",\"novalid\":{},\"key\":\"1592793103693\",\"model\":\"entry_date\",\"rules\":[]}],\"name\":\"\",\"key\":\"1592183795541\",\"model\":\"table_1592183795541\",\"rules\":[]},{\"type\":\"grid\",\"icon\":\"icon-RectangleCopy\",\"columns\":[{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184027111\",\"remoteOption\":\"option_1592184027111\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"名称\",\"novalid\":{},\"key\":\"1592184027111\",\"model\":\"name\",\"rules\":[],\"table\":\"SMS_ORDER\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592793011673\",\"remoteOption\":\"option_1592793011673\"},\"table\":\"SMS_ORDER\",\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"允许\",\"novalid\":{},\"key\":\"1592793011673\",\"model\":\"key\",\"rules\":[]},{\"type\":\"easy_search\",\"icon\":\"icon-easy-search\",\"options\":{\"defaultValue\":\"SearchBox\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"required\":false,\"options\":[{\"value\":\"TreeBox\",\"options\":[{\"type\":\"\",\"name\":\"\",\"searchType\":\"\",\"nodeName\":\"\",\"treeLeafOnly\":\"\",\"param\":\"\"}]},{\"value\":\"SearchBox\",\"options\":[{\"queryName\":\"selectConstructUnits\"}]}],\"remoteFunc\":\"func_1592797861100\",\"remoteOption\":\"option_1592797861100\"},\"table\":\"SMS_ORDER\",\"name\":\"管理者\",\"novalid\":{},\"key\":\"1592797861100\",\"model\":\"manager\",\"rules\":[]}]},{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184045106\",\"remoteOption\":\"option_1592184045106\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"性别\",\"novalid\":{},\"key\":\"1592184045106\",\"model\":\"sex\",\"rules\":[],\"table\":\"SMS_ORDER\"}]}],\"options\":{\"gutter\":0,\"justify\":\"start\",\"align\":\"top\",\"customClass\":\"\",\"hidden\":false,\"flex\":true,\"responsive\":false,\"remoteFunc\":\"func_1592184014765\",\"remoteOption\":\"option_1592184014765\"},\"name\":\"栅格布局\",\"key\":\"1592184014765\",\"model\":\"grid_1592184014765\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"30%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592296098724\",\"remoteOption\":\"option_1592296098724\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"型号\",\"key\":\"1592296098724\",\"model\":\"style\",\"rules\":[],\"table\":\"SMS_ORDER\"},{\"type\":\"textarea\",\"icon\":\"icon-diy-com-textarea\",\"options\":{\"width\":\"30%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"disabled\":false,\"pattern\":\"\",\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592296110884\",\"remoteOption\":\"option_1592296110884\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"备注\",\"key\":\"1592296110884\",\"model\":\"remark\",\"rules\":[],\"table\":\"SMS_ORDER\"}],\"config\":{\"labelWidth\":100,\"labelPosition\":\"right\",\"size\":\"small\",\"customClass\":\"\",\"ui\":\"element\",\"layout\":\"horizontal\",\"labelCol\":3,\"width\":\"100%\"}}";
                    contents = "{\"list\":[{\"type\":\"table\",\"tablename\":\"SMS_ORDER_DETAIL\",\"icon\":\"icon-table\",\"options\":{\"defaultValue\":[],\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"required\":false,\"remoteFunc\":\"func_1592183795541\",\"remoteOption\":\"option_1592183795541\"},\"tableColumns\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183804092\",\"remoteOption\":\"option_1592183804092\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"订单编号\",\"novalid\":{},\"key\":\"1592183804092\",\"model\":\"order_num\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183830591\",\"remoteOption\":\"option_1592183830591\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"名称\",\"novalid\":{},\"key\":\"1592183830591\",\"model\":\"name\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183846416\",\"remoteOption\":\"option_1592183846416\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"联系人\",\"novalid\":{},\"key\":\"1592183846416\",\"model\":\"linkman\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"200px\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592183862642\",\"remoteOption\":\"option_1592183862642\",\"tableColumn\":true},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"单价\",\"novalid\":{},\"key\":\"1592183862642\",\"model\":\"unit_price\",\"rules\":[],\"table\":\"SMS_ORDER_DETAIL\"},{\"type\":\"date\",\"icon\":\"icon-date\",\"options\":{\"defaultValue\":\"\",\"readonly\":false,\"disabled\":false,\"editable\":true,\"clearable\":true,\"placeholder\":\"\",\"startPlaceholder\":\"\",\"endPlaceholder\":\"\",\"type\":\"date\",\"format\":\"yyyy-MM-dd\",\"timestamp\":false,\"required\":false,\"requiredMessage\":\"\",\"width\":\"200px\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592793103693\",\"remoteOption\":\"option_1592793103693\",\"tableColumn\":true},\"table\":\"SMS_ORDER_DETAIL\",\"event\":{\"change\":\"\"},\"name\":\"日期\",\"novalid\":{},\"key\":\"1592793103693\",\"model\":\"entry_date\",\"rules\":[]}],\"name\":\"\",\"key\":\"1592183795541\",\"model\":\"table_1592183795541\",\"rules\":[]},{\"type\":\"grid\",\"icon\":\"icon-RectangleCopy\",\"columns\":[{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184027111\",\"remoteOption\":\"option_1592184027111\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"名称\",\"novalid\":{},\"key\":\"1592184027111\",\"model\":\"name\",\"rules\":[],\"table\":\"SMS_ORDER\"},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592793011673\",\"remoteOption\":\"option_1592793011673\"},\"table\":\"SMS_ORDER\",\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"允许\",\"novalid\":{},\"key\":\"1592793011673\",\"model\":\"key\",\"rules\":[]},{\"type\":\"easy_search\",\"icon\":\"icon-easy-search\",\"options\":{\"defaultValue\":\"SearchBox\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"required\":false,\"options\":[{\"value\":\"TreeBox\",\"options\":[{\"type\":\"\",\"name\":\"\",\"searchType\":\"\",\"nodeName\":\"\",\"treeLeafOnly\":\"\",\"param\":\"\"}]},{\"value\":\"SearchBox\",\"options\":[{\"queryName\":\"selectConstructUnits\"}]}],\"remoteFunc\":\"func_1592797861100\",\"remoteOption\":\"option_1592797861100\"},\"table\":\"SMS_ORDER\",\"name\":\"管理者\",\"novalid\":{},\"key\":\"1592797861100\",\"model\":\"manager\",\"rules\":[]}]},{\"span\":12,\"xs\":12,\"sm\":12,\"md\":12,\"lg\":12,\"xl\":12,\"list\":[{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592184045106\",\"remoteOption\":\"option_1592184045106\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"性别\",\"novalid\":{},\"key\":\"1592184045106\",\"model\":\"sex\",\"rules\":[],\"table\":\"SMS_ORDER\"}]}],\"options\":{\"gutter\":0,\"justify\":\"start\",\"align\":\"top\",\"customClass\":\"\",\"hidden\":false,\"flex\":true,\"responsive\":false,\"remoteFunc\":\"func_1592184014765\",\"remoteOption\":\"option_1592184014765\"},\"name\":\"栅格布局\",\"key\":\"1592184014765\",\"model\":\"grid_1592184014765\",\"rules\":[]},{\"type\":\"checkbox\",\"icon\":\"icon-check-box\",\"options\":{\"inline\":false,\"defaultValue\":[],\"showLabel\":false,\"options\":[{\"value\":\"Option 1\"},{\"value\":\"Option 2\"},{\"value\":\"Option 3\"}],\"required\":false,\"requiredMessage\":\"\",\"width\":\"\",\"remote\":true,\"remoteType\":\"dictionary\",\"remoteOption\":\"option_1593328433319\",\"remoteOptions\":[],\"props\":{\"value\":\"value\",\"label\":\"label\"},\"remoteFunc\":\"func_1593328433319\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"dictionary\":\"unit\"},\"table\":\"\",\"event\":{\"change\":\"\"},\"name\":\"多选框组\",\"key\":\"1593328433319\",\"model\":\"checkbox_1593328433319\",\"rules\":[]},{\"type\":\"radio\",\"icon\":\"icon-radio-active\",\"options\":{\"inline\":false,\"defaultValue\":\"\",\"showLabel\":false,\"options\":[{\"value\":\"Option 1\",\"label\":\"Option 1\"},{\"value\":\"Option 2\",\"label\":\"Option 2\"},{\"value\":\"Option 3\",\"label\":\"Option 3\"}],\"required\":false,\"requiredMessage\":\"\",\"width\":\"\",\"remote\":true,\"remoteType\":\"dictionary\",\"remoteOption\":\"option_1593328287179\",\"remoteOptions\":[],\"props\":{\"value\":\"value\",\"label\":\"label\"},\"remoteFunc\":\"func_1593328287179\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"disabled\":false,\"dictionary\":\"sex2\"},\"table\":\"SMS_ORDER\",\"event\":{\"change\":\"\"},\"name\":\"允许2\",\"key\":\"1593328287179\",\"model\":\"key2\",\"rules\":[]},{\"type\":\"input\",\"icon\":\"icon-input\",\"options\":{\"width\":\"30%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"dataType\":\"\",\"dataTypeCheck\":false,\"dataTypeMessage\":\"\",\"pattern\":\"\",\"patternCheck\":false,\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"disabled\":false,\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"showPassword\":false,\"remoteFunc\":\"func_1592296098724\",\"remoteOption\":\"option_1592296098724\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"型号\",\"key\":\"1592296098724\",\"model\":\"style\",\"rules\":[],\"table\":\"SMS_ORDER\"},{\"type\":\"textarea\",\"icon\":\"icon-diy-com-textarea\",\"options\":{\"width\":\"30%\",\"defaultValue\":\"\",\"required\":false,\"requiredMessage\":\"\",\"disabled\":false,\"pattern\":\"\",\"patternMessage\":\"\",\"placeholder\":\"\",\"customClass\":\"\",\"labelWidth\":100,\"isLabelWidth\":false,\"hidden\":false,\"dataBind\":true,\"remoteFunc\":\"func_1592296110884\",\"remoteOption\":\"option_1592296110884\"},\"event\":{\"blur\":\"\",\"change\":\"\"},\"name\":\"备注\",\"key\":\"1592296110884\",\"model\":\"remark\",\"rules\":[],\"table\":\"SMS_ORDER\"}],\"config\":{\"labelWidth\":100,\"labelPosition\":\"right\",\"size\":\"small\",\"customClass\":\"\",\"ui\":\"element\",\"layout\":\"horizontal\",\"labelCol\":3,\"width\":\"100%\"}}";
                }
            }

            JSONObject jsonObject = JSONObject.fromObject(contents);
            RootBean resultInfo = (RootBean) JSONObject.toBean(jsonObject, RootBean.class);

            List<SafFormslist> formList = safFormslistRepository.findByFormNo(formNo);
            SafFormslist form = formList.get(0);
            String mainTableName = commonUtilApplication.getTablesByFormId(form.getId(), 1);
            mainTableName = mainTableName.split(",")[0].toUpperCase();  //取第一个主表

            System.out.println("===开始解析Json=================");
            List<?> dataList = resultInfo.getList();
            MorphDynaBean mbean = null;
            List<Root> rootList = new ArrayList<Root>();
            Root root = null;
            DynaProperty[] dynaProperties = null;
            List<TableColumns> tableColumnsList = null;
            for (int i = 0; i < dataList.size(); i++) {

                mbean = (MorphDynaBean) dataList.get(i);
                tableColumnsList = new ArrayList<TableColumns>();
                root = new Root();
                dynaProperties = mbean.getDynaClass().getDynaProperties();

                for (int j = 0; j < dynaProperties.length; j++) {
                    String attrName = dynaProperties[j].getName();//属性名称

                    // System.out.println("attrName==="+attrName);
                    PublicAnalysis.getAttrNameType(attrName).getRootByAttrName(attrName, root, mbean, tableColumnsList);

                }
                rootList.add(root);
            } //dataList.size()
            //保存表单属性
            FormsAttributeQueryRequest queryRequest = new FormsAttributeQueryRequest();
            queryRequest.setId(form.getId());
            queryRequest.setFormNo(formNo);
            queryRequest.setRootList(rootList);
            queryRequest.setJson(contents);
            queryRequest.setTableName(mainTableName);

            Map<String, Object> bakmap = formsDesignApplication.saveFormAttribute(queryRequest, form);

            if ("1".equals(bakmap.get("success").toString())) {
                map.put("success", "1");
                //生成表单页面

                SafFormsQueryRequest formQueryRequest = new SafFormsQueryRequest();
                // String pageName=CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,tableName);
                formQueryRequest.setId(form.getId());
                formQueryRequest.setFormNo(formNo);
                formQueryRequest.setTableName(mainTableName);
                safFormsApplication.needGenerateFile(formNo);
            } else {
                map.put("reason", bakmap.get("reason"));
            }

            map.put("success", "1");

        } catch (Exception ex) {
            map.put("success", "0");
            map.put("reason", ex.getMessage());
            ex.printStackTrace();
        }
        return toResult(map);


    }

    // 输出数据
    protected void renderData(HttpServletResponse response, String data) {
        PrintWriter printWriter = null;
        try {
            printWriter = response.getWriter();
            printWriter.print(data);
        } catch (IOException ex) {

        } finally {
            if (null != printWriter) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }
}
