package com.huigou.uasp.form.application;

import java.util.List;
import java.util.Map;

import com.huigou.uasp.form.domain.query.SafFormsQueryRequest;
import com.huigou.uasp.model.domain.query.DbTablesQueryRequest;


public interface CommonUtilApplication {

	//查询数据库的当前时间
     String queryDBCurrentDate();
		  
		
	  //查询表单中的表    tableType:1主表 2 明细表 
	  String getTablesByFormId(String formId,int tableType);
	  
	   /*
	      * 查询表单主表属性字段
	      * @see 字段个数默认最大100
	      */
	   List<Map<String, Object>> queryDataRecordSingleFields(String formId,String tableName);
	   
	   
	   /*
	      * 查询表单明细表中的字段属性
	      * @see 字段个数默认最大100
	      */
	   List<Map<String, Object>> queryDataRecordMultsFields(String formId,String tableName);
	  
	   /*
	      * 查询表单模型包含的表字段
	      * @see 字段个数默认最大100
	      */
	   List<Map<String, Object>> queryFormTableFields(String formNo,String tableName);
	   
	   
	   /**
	    * 获取表中隐藏字段
	    */
	   List<String> queryTableHiddenFields(DbTablesQueryRequest queryRequest,int toCamel);
	   
	   /**
		  * 获取检索SQL中的隐藏字段
		  */
      List<String> querySearchSQLHiddenFields(String  formNo);

	 //获取流程定义的信息
	  String getProcDefinitionByFormNo(String formNo);

	/*
	 * 查询表单返回的值
	 * 返回 List <Map>
	 */
	List<Map<String, Object>> queryFormTableDatas(String sql);
}
