package com.huigou.uasp.data.controller;

import java.util.List;
import java.util.Map;

import com.huigou.uasp.bpm.managment.domain.model.ProcDefinition;
import com.huigou.uasp.bpm.managment.repository.ProcDefinitionRespository;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.builder.vo.ParamFormVO;
import com.huigou.uasp.builder.vo.PubDataRecord;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.form.application.CommonUtilApplication;
import com.huigou.uasp.form.domain.model.FormTables;
import com.huigou.uasp.form.domain.model.SafFormslist;
import com.huigou.uasp.form.repository.FormTablesRepository;
import com.huigou.uasp.form.repository.SafFormslistRepository;
import com.huigou.uasp.data.application.DataRecordApplication;
import com.huigou.uasp.data.domain.query.DataRecordQueryRequest;
import com.huigou.util.SDO;

@Controller
@ControllerMapping( "menuManage" ) 
public class MenuManageController  extends CommonController{ 

	@Autowired
	private  SafFormslistRepository safFormslistRepository;
	
	@Autowired
	private  FormTablesRepository formTablesRepository;
	
	@Autowired
	private  DataRecordApplication dataRecordApplication;
	
	@Autowired
	private  CommonUtilApplication  commonUtilApplication;

	@Autowired
	private ProcDefinitionRespository procDefinitionRespository;

	@Override
	protected String getPagePath(){
		return "/customform/";
	}
	
	//@SkipAuth
	 public String forwardPageList(){
			SDO sdo = this.getSDO(); 
		  String olddata="0";
		   if ("1".equals(sdo.getString("olddata"))){
		   	olddata="1";
		  } 
		/* this.putAttribute("olddata",olddata);
		 MdmDataRecordQueryRequest queryRequest = getSDO().toQueryRequest(MdmDataRecordQueryRequest.class); 
		 queryRequest.setDisplayListing(1); //只查询列表显示的列
		 ParamFormVO  paraForm=mdmDataRecordApplication.getFieldAttributes(queryRequest);
		this.putAttribute("modelId",  queryRequest.getModelId());
		this.putAttribute("fieldEns", StringUtils.join(paraForm.getFieldEns(), ","));
		this.putAttribute("fieldChs", StringUtils.join(paraForm.getFieldChs(), ","));
		this.putAttribute("fieldTypes",StringUtils.join(paraForm.getDisplayFieldTypes(), ","));
		this.putAttribute("dataSourceTypes",StringUtils.join(paraForm.getDataSourceTypes(), ","));
		this.putAttribute("dataSources",StringUtils.join(paraForm.getDataSources(), ","));*/
		   String formNo=sdo.getString("formNo");
		 List <SafFormslist>list=safFormslistRepository.findByFormNo(formNo);
		 SafFormslist safFormslist=list.get(0);
		 
		 String tableName=commonUtilApplication.getTablesByFormId(safFormslist.getId(),1);
		 tableName=tableName.split(",")[0];  //取第一个主表 
		 
		  String pageName= "/"+formNo+"/"+CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,tableName)+"List";
		  // smsOrderList
		  this.putAttribute("formNo",formNo);

		 // 查询当前表单是否挂流程
		 // String sql="select * from WF_PROCDEF t where t.node_kind_id='proc' and t.form_no='"+safFormslist.getFormNo()+"'";
		 //  List<?> proclist=this.generalRepository.queryByNativeSql(sql,new HashMap<String, Object>());
		/* ProcDefinition procDefinition = this.procDefinitionRespository.findOne(((root, query, cb) ->
				 cb.and(cb.equal(root.get("formNo"), formNo),
						 cb.equal(root.get("nodeKindId"), "proc"))
		 ));
		 String procId="";
		 if (procDefinition!=null) {
			 procId= procDefinition.getProcId();
		 }*/
		 this.putAttribute("procId", commonUtilApplication.getProcDefinitionByFormNo(formNo));
		 //this.putAttribute("formNo",procDefinition.getCode());
		  return forward(pageName);
	}
	 
		
	
}
