package com.huigou.uasp.builder.filer;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.vo.ParamFormVO;

import com.huigou.uasp.util.Utils;

@Service("buildRepositoryFile")
public class BuildRepositoryFile implements BuildFilerInter {
	
	private ParamFormVO paraForm;
    
	@Override
	public String generateFile(ParamFormVO paraForm,List<Map<String, Object>> fieldList)  throws Exception{
		  
		  File file=new File(paraForm.getSrcPath()+"/repository");
		  if (!file.exists()){
			  file.mkdir();
		  }
		
		  //tableName=tableName.toLowerCase();
		 String clsName= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,paraForm.getTableName());
		  clsName=Utils.toUpperCaseFirstOne(clsName);
		  String entityName=clsName;
		  clsName+="Repository";
		  //String clsName=CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE,tableName);
		// Java 源代码
		       StringBuffer sb=new StringBuffer("");
				sb.append("package ").append(paraForm.getPackageName()).append(".repository;\r\n ");
			    sb.append("	import org.springframework.data.jpa.repository.JpaRepository;\r\n");
			    sb.append("	import org.springframework.data.jpa.repository.Query;\r\n");
			    sb.append(" import java.util.List;\r\n");
			    sb.append("	import ").append(paraForm.getPackageName()).append(".domain.model.").append(entityName).append(";\r\n");
			    sb.append("\r\n");
			   	sb.append("public interface "+clsName+" extends JpaRepository<").append(entityName).append(",String>{ \r\n ");
							    
			   	sb.append("/*  说明：\r\n ");
			   	sb.append("      1)、原生sql访问方式：\r\n");
			   	sb.append("   @Query(value = \"SELECT PM.* FROM PM_MESSAGE PM WHERE PM.ID IN (SELECT PMR.MESSAGE_ID FROM PM_MESSAGE_RECEIVER PMR WHERE PMR.RECEIVER_ID = ?1)\",nativeQuery = true)\r\n");
			   	sb.append("    List<Message> findById(String personId);\r\n");
			   	sb.append("      2)、HQL访问方式：\r\n");
			   	sb.append("   @Query(\"from Propertyclass s where  s.pmId=?1 and propertyClassid=?2 \") \r\n");
			   	sb.append("    List <Propertyclass> searchPropertyClassDetails(String pmId,String classId);\r\n");
				sb.append("     3)、通过方法名称生成查询  （参见JPA访问数据库方式）\r\n ");
  			    sb.append("   List <Message>  findById(String id);\r\n");
				
				sb.append("   @Modifying注解    \r\n");
				sb.append("   @Query(\"UPDATE User u SET u.name = :name WHERE u.id = :id\")\r\n");
				sb.append("  void updateTable(@Param(\"name\") String name, @Param(\"id\")Integer id);\r\n");
			 
				sb.append("   @Modifying注解    \r\n");
				sb.append("   @Query(\"delete from User u WHERE u.id in :idList\")    \r\n");
				sb.append("  void deleteByIds(@Param(\"idList\")List<Integer> idList);  \r\n");
				sb.append("  */  \r\n");
				sb.append("  \r\n");
				
				 sb.append(" List <").append(entityName).append(">  findById(String id);\r\n");
				 
				 sb.append("}");
			     
				String realPath=paraForm.getUploadPath()+"/"+paraForm.getPackageName().replaceAll("\\.","/");
				realPath+="/repository/"+clsName+".java";
				return Utils.generateJava(realPath, sb);
	
	}

}
