package com.huigou.uasp.builder.filer;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.base.CaseFormat;
import com.huigou.cache.SystemCache;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.vo.ParamFormVO;

import com.huigou.uasp.util.Utils;

@Service("buildPageListFile")
public class BuildPageListFile implements BuildFilerInter {
	

	
	@Override
	public String generateFile(ParamFormVO paraForm,List<Map<String, Object>> fieldList) throws Exception{
		 // String srcPath=paraForm.getUploadPath()+"/source";
	     // String webPath=path.substring(1,path.length()-16);
		  StringBuffer sb=new StringBuffer("");
		  
		  String clsName= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,paraForm.getTableName());
		  String fileName=clsName; //首字母小写
		  clsName=Utils.toUpperCaseFirstOne(clsName); //首字母大写
		  
		  sb.append("<%@ page language=\"java\" contentType=\"text/html; charset=utf-8\"%>\r\n");
		  sb.append("<%@taglib uri=\"/WEB-INF/taglib.tld\" prefix=\"x\"%>\r\n");
		  sb.append("<%@ taglib uri=\"http://java.sun.com/jsp/jstl/core\" prefix=\"c\"%>\r\n");
		  sb.append("<html>\r\n");
		  sb.append("<head>\r\n");
		  
		  sb.append("<x:base include=\"layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog\" />\r\n");
		  sb.append("<script src='<c:url value=\"/lib/jquery/jquery.comboDialog.js\"/>' type=\"text/javascript\"></script>\r\n");
		  sb.append("<script src='<c:url value=\"/lib/jquery/jquery.commonTree.js\"/>' type=\"text/javascript\"></script>\r\n");
		  sb.append("<script src='<c:url value=\"/lib/jquery/jquery.flexField.js\"/>' type=\"text/javascript\"></script>\r\n");
		  
		  String JsPath="";
		  if (paraForm.getIsform()==1){ //表单生成器 生成页面
			  JsPath=paraForm.getFormPath();
			  JsPath=JsPath.substring(JsPath.indexOf("customform"));
			 sb.append("<script src='<c:url value=\"/").append(JsPath).append("/").append(fileName).append("List.js\"/>' type=\"text/javascript\"></script>\r\n");
		  } else {  //生成源码 的
		     sb.append("<script src='<c:url value=\"/biz/").append(paraForm.getFormPath()).append("/").append(fileName).append("List.js\"/>' type=\"text/javascript\"></script>\r\n");
		  }

		  sb.append("</head>\r\n");
		  sb.append(" <body>\r\n");
		//  sb.append(" 	<x:hidden name=\"id\" />\r\n");
		
		 
		 sb.append(" <div class=\"container-fluid\">\r\n");
		  sb.append(" <div id=\"layout\">\r\n");
	     //拼接标题			
		 sb.append("<div position=\"center\" title=\"").append(paraForm.getFormName()).append("\">\r\n");
		 sb.append("	<x:title title=\"搜索\" hideTable=\"queryMainForm\" isHide=\"true\" />\r\n");
	     if (paraForm.getIsform()==1){ //表单生成器 生成页面
	    	 sb.append("   <x:hidden name=\"formNo\" />\r\n");
			 sb.append("   <x:hidden name=\"procId\" />\r\n");
	     }
	     sb.append("  <form class=\"hg-form ui-hide\" method=\"post\" action=\"\" id=\"queryMainForm\">\r\n");

		 sb.append("	<div class=\"hg-form-row\">\r\n");
		 //拼接查询字段
		// String searchField=pageMap.get("listdisplaySearchField").toString();
		 String []searchFields=paraForm.getSearchFields();
		 String []fieldEns=paraForm.getFieldEns();
		 String []realfields=paraForm.getRealFieldEns();
		 String []fieldchs=paraForm.getFieldChs();
		 String []fieldTags=paraForm.getFieldTags();
		 String []dataSourceTypes=paraForm.getDataSourceTypes();
		 String []dataSources=paraForm.getDataSources();
		 
		 String tagType="input",chName="",dataSourceType="",dataSource="",searchField="";
		 for (int i=0;i<searchFields.length;i++) {
			if ("1".equals(searchFields[i])){ //
				 if (paraForm.getIsform() == 0) {  //是代码生成器 获取真实字段名称
					 searchField = realfields[i];
				  } else {
					 searchField = fieldEns[i];
				  }
					 chName=fieldchs[i];
					 tagType=fieldTags[i];
					 if (dataSourceTypes.length>i){
					    dataSourceType=dataSourceTypes[i]; 
					 }
					 if (dataSources.length>i){
					   dataSource=dataSources[i];
					 }
			 if ("select".equals(tagType)){ //数据字典 dataSourceType=3 
				sb.append("     <x:selectC name=\"").append(searchField).append("\" label=\"")
				 .append(chName).append("\" dictionary=\"").append(dataSource).append("\" emptyOption=\"true\" labelCol=\"1\" />\r\n");
			 }else if ("input".equals(tagType)){
			    sb.append("		<x:inputC name=\"").append(searchField)
			    .append("\" label=\"").append(chName).append("\" labelCol=\"1\" />\r\n");
			 }else if ("date".equals(tagType)){
				 sb.append("    <x:inputC name=\"start").append(Utils.toUpperCaseFirstOne(searchField)).append("\" wrapper=\"date\" label=\"").append(chName).append("从\" labelCol=\"1\"/>\r\n");
				 sb.append("	<x:inputC name=\"end").append(Utils.toUpperCaseFirstOne(searchField)).append("\" wrapper=\"date\" label=\"至\" labelCol=\"1\"/>\r\n");
				  // <x:inputL name="completeDate"    label="竣工日期起" readonly="false" wrapper="date" />
				  // <x:inputL name="endcompleteDate"  label="止" readonly="false" wrapper="date"   />
		     }
			} //searchFields[i]==1

		 }
		 sb.append("		<x:searchButtons />\r\n");
		 sb.append("	</div>\r\n");
		 sb.append("	</form>\r\n");
		 sb.append("	<div id=\"").append(fileName).append("Grid\" style=\"margin:2px;\"></div>\r\n");
		 sb.append("    </div>\r\n");
		 sb.append("    </div>\r\n");
		 sb.append("    </div>\r\n");
	     sb.append(" </body>\r\n");
				
		  sb.append("</html>\r\n");
	      
				
		 String filePathName=paraForm.getUploadPath()+"/"+paraForm.getFormPath()+"/"+fileName+"List.jsp";
		 return Utils.generateFile(filePathName,sb);

	}

}
