package com.huigou.uasp.builder.filer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.base.CaseFormat;
import com.huigou.uasp.builder.BuildFilerInter;
import com.huigou.uasp.builder.vo.ParamFormVO;

import com.huigou.uasp.util.Utils;


@Service("buildControllerFile")
public class BuildControllerFile implements BuildFilerInter {
	
	
	@Override
	public String generateFile(ParamFormVO paraForm,List<Map<String, Object>> fieldList)  throws Exception{
		File file=new File(paraForm.getSrcPath()+"/controller");
		  if (!file.exists()){
			  file.mkdir();
		  }

		  //tableName=tableName.toLowerCase();
		  String clsName= CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL,paraForm.getTableName());
		  String controllerName=clsName; // 首字母小写
		  clsName=Utils.toUpperCaseFirstOne(clsName);  //首字母大写
		  String entityName=clsName; 
		  clsName+="Controller";
		   StringBuffer sb=new StringBuffer("");
		  // Map <String, Object>pageMap=list.get(0);
		  // int existAttachment=Integer.parseInt(pageMap.get("existAttachment").toString());
			  SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
	
		   sb.append("package ").append(paraForm.getPackageName()).append(".controller;\r\n ");

		   sb.append("import java.util.List;\r\n");
		   sb.append("import java.util.Map;\r\n");
		   
		   sb.append("import org.springframework.beans.factory.annotation.Autowired;\r\n");
		   sb.append("import org.springframework.stereotype.Controller;\r\n");
		   sb.append("import com.huigou.uasp.annotation.ControllerMapping;\r\n");
		   sb.append("import com.huigou.uasp.client.CommonController;\r\n");
		   sb.append("import com.huigou.util.CommonUtil;\r\n");
		   sb.append("import com.huigou.util.SDO;\r\n");
		   sb.append("import org.springframework.util.StringUtils;\r\n");
		   
		   sb.append("import ").append(paraForm.getPackageName()).append(".domain.model.").append(entityName).append(";\r\n");
		   sb.append("import ").append(paraForm.getPackageName()).append(".repository.").append(entityName).append("Repository;\r\n");
		   sb.append("import ").append(paraForm.getPackageName()).append(".application.").append(entityName).append("Application;\r\n");
		   sb.append("import ").append(paraForm.getPackageName()).append(".domain.query.").append(entityName).append("QueryRequest;\r\n");
		
		   sb.append("\r\n");	
		   
		   sb.append("/**\r\n");
		   sb.append(" * @author BySystem \r\n");
		   sb.append(" * @date ").append(sdf.format(new Date())).append("\r\n");
		   sb.append(" * @Description ").append(paraForm.getFormName()).append("的控制类\r\n");
		   sb.append(" */ \r\n");

		   sb.append("@Controller\r\n");
		   sb.append("@ControllerMapping(value = \"").append(controllerName).append("\")\r\n");
		   sb.append(" public class ").append(clsName).append(" extends CommonController{ \r\n");
		   sb.append("\r\n");
	
		   sb.append("@Autowired\r\n");
		   sb.append("private ").append(entityName).append("Repository ").append(controllerName).append("Repository;\r\n");
		   sb.append("\r\n");
		   sb.append("@Autowired\r\n");
		   sb.append("private ").append(entityName).append("Application ").append(controllerName).append("Application;\r\n");
		   sb.append("\r\n");
		
		   sb.append("@Override\r\n");
		   sb.append("protected String getPagePath(){\r\n");
		   sb.append("	return \"/biz/").append(paraForm.getFormPath()).append("/\";\r\n");
		   sb.append("}\r\n");
		   
		   sb.append("\r\n");
		   
		   sb.append(" //跳转主页方法 \r\n");
		   sb.append(" public String forward").append(entityName).append("List(){\r\n");
		   sb.append("	 return forward(\"").append(controllerName).append("List\");\r\n");
		   sb.append("}\r\n");
		   
		   sb.append("/**\r\n");
		   sb.append(" * 查询表\r\n");
		   sb.append(" * @return \r\n");
		   sb.append(" */\r\n");
		   
		   sb.append(" public String slicedQuery").append(entityName).append("() { \r\n");
		   sb.append(" 	SDO sdo = this.getSDO(); \r\n");
		   sb.append("   ").append(entityName).append("QueryRequest queryRequest = sdo.toQueryRequest(").append(entityName).append("QueryRequest.class); \r\n");
		 		  
		   sb.append("   Map<String, Object> data = this.").append(controllerName).append("Application.query").append(entityName).append("(queryRequest); \r\n");
		   sb.append("	  return toResult(data);\r\n");
		   sb.append("	 }\r\n");
		   sb.append("\r\n");
		  		     
         //查看明细方法		  
		   sb.append(" //查询明细方法\r\n");
		   sb.append("public String load").append(entityName).append("Detail() {\r\n");
		    sb.append("   String id = getSDO().getString(\"id\");\r\n");

		    sb.append(" if (StringUtils.isEmpty(id)) {\r\n");
	
		    if (paraForm.getExistAttachment()==1){
		       sb.append("    this.putAttribute(\"attbizid\",CommonUtil.createGUID()); //自动生成附件id \r\n");
		    }
			sb.append("	      return forward(\"").append(controllerName).append("Detail\");\r\n");
			sb.append("  }else {\r\n");
			sb.append("	     ").append(entityName).append(" entity = this.").append(controllerName).append("Application.load").append(entityName).append("(id);\r\n");
			sb.append("	      return forward(\"").append(controllerName).append("Detail\",entity);\r\n");
		    sb.append("   }\r\n");
		   sb.append("}\r\n");
		   sb.append("\r\n");
		   
		   	 //保存数据方法
		   sb.append(" //保存方法\r\n");
		   sb.append(" public String save").append(entityName).append("() {\r\n");
		   sb.append("     SDO sdo = getSDO();\r\n");
		  //  sb.append("String orgLevel=sdo.getString("orgLevel");\r\n");
			sb.append("   ").append(entityName).append("  entity = (").append(entityName).append(") sdo.toObject(").append(entityName).append(".class);\r\n");
			sb.append("   this.").append(controllerName).append("Repository.save").append("(entity);\r\n");
	        sb.append("   return success();\r\n");
			
		   sb.append("	 }\r\n");
		   sb.append("\r\n");
		   
		   //删除方法
		   sb.append(" //删除方法\r\n");
		   sb.append("public String delete").append(entityName).append("s() {\r\n");
		   sb.append("    this.").append(controllerName).append("Application.delete").append(entityName).append("ByIds(getSDO().getIds());\r\n");
		   sb.append("	  return success();\r\n");
		   sb.append("}\r\n");
		   sb.append("\r\n");
		   
		   boolean isChangStatus=false;
		   String []btnMethods=paraForm.getBtnMethodNames();
		   for (int u=0;u<btnMethods.length;u++){
			   if (btnMethods[u].equals("enable")){
				   isChangStatus=true;
			   }
		   }
		  if (isChangStatus){ //
		   //修改状态 
		   sb.append(" //修改状态\r\n");
		   sb.append(" public String change").append(entityName).append("Status(){\r\n");
		   sb.append("	   SDO sdo=this.getSDO();\r\n");
		   sb.append("     ").append(entityName).append(" entity=this.").append(controllerName).append("Application.load").append(entityName).append("(sdo.getString(\"id\"));\r\n");
		   sb.append("    if(entity!=null){\r\n");
		   sb.append("		entity.setStatus(sdo.getInteger(\"status\"));\r\n");
		   sb.append("	  }\r\n");
		   sb.append("    this.").append(controllerName).append("Repository.save").append("(entity);\r\n");
	       sb.append("    return success();\r\n");
		   sb.append("	}\r\n");
		   }
		   sb.append(" }\r\n");
		   
		   String realPath=paraForm.getUploadPath()+"/"+paraForm.getPackageName().replaceAll("\\.","/");
			 realPath+="/controller/"+clsName+".java";
			return Utils.generateJava(realPath, sb);

	}

}
