package com.huigou.uasp.builder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.huigou.uasp.builder.filer.BuildApplicationFile;
import com.huigou.uasp.builder.filer.BuildControllerFile;
import com.huigou.uasp.builder.filer.BuildEntityFile;
import com.huigou.uasp.builder.filer.BuildPageDetailFile;
import com.huigou.uasp.builder.filer.BuildPageJSFile;
import com.huigou.uasp.builder.filer.BuildPageListFile;
import com.huigou.uasp.builder.filer.BuildQueryRequestFile;
import com.huigou.uasp.builder.filer.BuildRepositoryFile;
import com.huigou.uasp.builder.filer.BuildXMLFile;

import com.huigou.uasp.util.Constant;


@Service("buildTypeClass")
public class BuildTypeClass {

	@Autowired
	private BuildApplicationFile buildApplicationFile;
	@Autowired
	private BuildControllerFile buildControllerFile;
	@Autowired
	private BuildEntityFile buildEntityFile;
	@Autowired
	private BuildPageDetailFile buildPageDetailFile;
	
	@Autowired
	private BuildPageJSFile buildPageJSFile;
	@Autowired
	private BuildPageListFile buildPageListFile;
	@Autowired
	private BuildQueryRequestFile buildQueryRequestFile;
	@Autowired
	private BuildRepositoryFile buildQueryRepositoryFile;
	@Autowired
	private BuildXMLFile buildXMLFile;
	
	/*
	 * 获取文件构建服务类名称
	 */
	public  BuildFilerInter getBuildClass(String buildType) {
		BuildFilerInter result = null;
		switch (buildType) // 服务类型
		{
		case Constant.BUILD_APPLICATION:
			result = buildApplicationFile;
 		   break;
		case Constant.BUILD_CONTROLLER:
			result = buildControllerFile;
			break;	
		case Constant.BUILD_ENTITY:
			result = buildEntityFile;
			break;	
		case Constant.BUILD_PAGEDETAIL:
			result = buildPageDetailFile;
			break;	
		case Constant.BUILD_PAGEJS:
			result = buildPageJSFile;
			break;
		case Constant.BUILD_PAGELIST:
			result = buildPageListFile;
			break;
		case Constant.BUILD_QUERYREQUEST:
			result = buildQueryRequestFile;
			break;
		case Constant.BUILD_REPOSITORY:
			result = buildQueryRepositoryFile;
			break;
		case Constant.BUILD_XML:
			result = buildXMLFile;
			break;
		 default:
			result = null;
		}
		return result;
	}
	
	
	
}
