package com.huigou.explorer.converters.mxgraph;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.*;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

/**
 * <pre>
 *      <object code="exclusive_gateway41" id="41">
 *             <mxCell style="shape=workflow.gateways.exclusive_gateway;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2"
 *                     vertex="1" parent="1">
 *                 <mxGeometry x="362" y="350" width="38" height="39" as="geometry"/>
 *             </mxCell>
 *         </object>
 * </pre>
 *
 * @author yonghuan
 */
public class MxGatewayConverter extends AbstractMxVertexConverter implements MxElementConverter {

    private final static String VERTEX_STYLE_PATTERN = "shape=workflow.gateways.%s;whiteSpace=wrap;html=1;fillColor=#ffffff;strokeColor=#585858;strokeWidth=2";

    @Override
    public boolean supports(BaseElement baseElement) {
        return baseElement instanceof Gateway;
    }

    @Override
    protected void convertInternal(BpmnModel bpmnModel, Process process, mxGraph graph, FlowElement fe, mxCell vertex) {
        vertex.setStyle(String.format(VERTEX_STYLE_PATTERN, camelCaseToUnderscoreCase(fe.getClass().getSimpleName())));
        Gateway gateway = (Gateway) fe;
        String defaultFlow = gateway.getDefaultFlow();
        if (StringUtils.isNotBlank(defaultFlow)) {
            vertex.setAttribute("defaultFlow", defaultFlow);
        }
    }
}
