package com.huigou.explorer.converters.mxgraph;

import com.alibaba.fastjson.JSON;
import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.*;

/**
 * @author yonghuan
 */
public class MxCallActivityConverter extends AbstractMxVertexConverter implements MxElementConverter {

    @Override
    public boolean supports(BaseElement baseElement) {
        return baseElement.getClass() == CallActivity.class;
    }

    @Override
    protected void convertInternal(BpmnModel bpmnModel, Process process, mxGraph graph, FlowElement fe, mxCell vertex) {
        CallActivity callActivity = (CallActivity) fe;
        vertex.setAttribute("calledElement", callActivity.getCalledElement());
        vertex.setAttribute("isForCompensation", String.valueOf(callActivity.isForCompensation()));
        if (callActivity.getInParameters().size() > 0) {
            vertex.setAttribute("inParameters", JSON.toJSONString(callActivity.getInParameters()));
        }
        if (callActivity.getOutParameters().size() > 0) {
            vertex.setAttribute("outParameters", JSON.toJSONString(callActivity.getOutParameters()));
        }
    }
}
