package com.huigou.explorer.converters.bpmn;

import com.mxgraph.model.mxGraphModel;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;

/**
 * mxgraph XML 转换为 bpmnModel
 *
 * @author yonghuan
 */
public interface ElementConverter {

    boolean supports(Object mxElement);

    void convert(BpmnModel bpmnModel, mxGraphModel graphModel, Object mxElement);

    default ExtensionElement addFieldExtensionElement(BaseElement be, String fieldName, String fieldValue) {
        ExtensionElement field = new ExtensionElement();
        field.setNamespace("http://activiti.org/bpmn");
        field.setNamespacePrefix("activiti");
        field.setName("field");
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(fieldName);
        extensionAttribute.setValue(fieldValue);
        field.addAttribute(extensionAttribute);
        be.addExtensionElement(field);
        return field;
    }

}
