package com.huigou.demo.application.impl;

import com.huigou.uasp.bpm.engine.application.ProcUnitHandlerApplication;
import com.huigou.uasp.bpm.engine.domain.model.ProcUnitHandler;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MyActivitiEventListener implements ActivitiEventListener {

    private final static Logger LOG = LoggerFactory.getLogger(MyActivitiEventListener.class);
    @Autowired
    private ProcUnitHandlerApplication procUnitHandlerApplication;

    @Override
    public void onEvent(ActivitiEvent event) {
        ActivitiEventType eventType = event.getType();
        if (event.getType() == ActivitiEventType.TASK_ASSIGNED) {
            Task task = (Task) ((ActivitiEntityEventImpl) event).getEntity();
            String assignee = task.getAssignee();
            ProcUnitHandler procUnitHandler = procUnitHandlerApplication.loadProcUnitHandler(assignee);
            LOG.info("指派任务，procUnitHandler是：{}", procUnitHandler);
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}
