package com.huigou.demo.application.impl;


import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.demo.application.LeaveApplication;
import com.huigou.demo.domain.model.Leave;
import com.huigou.demo.domain.query.LeaveQuery;
import com.huigou.demo.mapper.LeaveMapper;
import com.huigou.demo.repository.LeaveRepository;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author yonghuan
 */
@Service("leaveApplication")
public class LeaveApplicationImpl extends FlowBroker implements LeaveApplication {

    private LeaveRepository leaveRepository;
    private LeaveMapper leaveMapper;

    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    public void test() {
        Task task = taskService.createTaskQuery().taskId("taskId").singleResult();
       ProcessInstance pi = runtimeService.createProcessInstanceQuery()
                .processInstanceId( task.getProcessInstanceId())
                .singleResult();
    }

    @Autowired
    public void setLeaveRepository(LeaveRepository leaveRepository) {
        this.leaveRepository = leaveRepository;
    }

    @Autowired
    public void setLeaveMapper(LeaveMapper leaveMapper) {
        this.leaveMapper = leaveMapper;
    }


    @Override
    public Leave loadLeaveById(String id) {
        return leaveRepository.findOne(id);
    }

    @Override
    public Map<String, Object> slicedQuery(LeaveQuery query) {
        return leaveMapper.slicedQuery(query);
    }


    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        Leave leave = getBizEntity(Leave.class);
        if (leave.isNew()) {
            leave.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            leave = (Leave) commonDomainService.loadAndFillinProperties(leave);
        }
        leave = leaveRepository.save(leave);

        return leave.getId();
    }



    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(leaveRepository.getOne(bizId));
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        Leave leave = leaveRepository.findOne(bizId);
        leave.setStatusId(status.getId());
        leaveRepository.save(leave);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        Leave leave = leaveRepository.findOne(bizId);
        leave.setStatusId(BizBillStatus.ABORTED.getId());
        leaveRepository.save(leave);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            Leave leave = leaveRepository.findOne(bizId);
            leave.setStatusId(BizBillStatus.APPLYING.getId());
            leaveRepository.save(leave);
        }
    }

}
