package com.huigou.bpm.management.repository;

import com.huigou.bpm.management.domain.model.ServiceParamMapping;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author yonghuan
 */
public interface ServiceParamMappingRepository extends JpaRepository<ServiceParamMapping, String> {

    /**
     * 删除流程节点变量绑定的服务参数。
     *
     * @param procdefId    流程定义id
     * @param activityCode 流程节点编码
     */
    @Query("delete from ServiceParamMapping where variableId in (select v.id from ProcessVariable v where v.procdefId=?1) and activityCode=?2")
    @Modifying
    void deleteAll(String procdefId, String activityCode);

    /**
     * 查询流程节点变量绑定的服务参数。
     *
     * @param procdefId    流程定义id
     * @param activityCode 流程节点编码
     * @return ServiceParamMapping
     */
    @Query("from ServiceParamMapping where variableId in (select v.id from ProcessVariable v where v.procdefId=?1) and activityCode=?2")
    List<ServiceParamMapping> findAll(String procdefId, String activityCode);

}
