package com.huigou.bpm.management.repository;

import com.huigou.bpm.management.domain.model.ProcessDefinition;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author yonghuan
 * @since 1.1.3
 */
public interface ProcessDefinitionRepository extends JpaRepository<ProcessDefinition, String> {

    /**
     * 根据流程定义code查询流程定义。
     *
     * @param code 流程定义code
     * @return 查询到阿流程定义
     */
    ProcessDefinition findByCode(String code);

    /**
     * 根据parentId统计流程定义数量。
     *
     * @param parentId parentId
     * @return 流程定义数量
     */
    long countByParentId(String parentId);

    /**
     * 更新流程定义的状态
     *
     * @param status 状态。
     * @param ids    流程定义id
     */
    @Query("update ProcessDefinition set status=?1 where id in (?2)")
    @Modifying
    void updateStatusByIds(int status, List<String> ids);
}
