package com.huigou.bpm.management.domain.model;

import java.util.Arrays;
import java.util.Optional;

/**
 * 流程图类型
 *
 * @author yonghuan
 */
public enum ChartKind {
    /**
     * BPMN2 流程图
     */
    BPMN2("process.bpmn2"),
    /**
     * 普通流程图
     */
    FLOWCHART("process.flowchart"),
    /**
     * 企业价值链图
     */
    EVC("process.evc"),
    /**
     * 组织结构图
     */
    ORG("chart.organizationchart");

    public final String id;

    ChartKind(String id) {
        this.id = id;
    }

    public static Optional<ChartKind> fromId(String id) {
        return Arrays.stream(values()).filter(kind -> kind.id.equals(id)).findFirst();
    }
}
