package com.huigou.bpm.management.application.impl;

import com.huigou.bpm.management.application.ServiceParamApplication;
import com.huigou.bpm.management.domain.model.ServiceParam;
import com.huigou.bpm.management.domain.query.ServiceParamMappingQueryRequest;
import com.huigou.bpm.management.domain.query.ServiceParamQueryRequest;
import com.huigou.bpm.management.mapper.ServiceParamMapper;
import com.huigou.bpm.management.repository.ServiceParamRepository;
import com.huigou.data.domain.model.CommonDomainConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
@Service
public class ServiceParamApplicationImpl implements ServiceParamApplication {

    private ServiceParamRepository serviceParamRepository;
    private ServiceParamMapper serviceParamMapper;

    @Autowired
    public void setServiceParamRepository(ServiceParamRepository serviceParamRepository) {
        this.serviceParamRepository = serviceParamRepository;
    }

    @Autowired
    public void setServiceParamMapper(ServiceParamMapper serviceParamMapper) {
        this.serviceParamMapper = serviceParamMapper;
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public ServiceParam add(ServiceParam param) {
        checkCode(param);
        return serviceParamRepository.save(param);
    }

    private void checkCode(ServiceParam param) {
        ServiceParam paramInDb = serviceParamRepository.findByServiceIdAndCode(param.getServiceId(), param.getCode());
        if (param.isNew()) {
            Assert.isNull(paramInDb, CommonDomainConstants.CODE_NOT_DUPLICATE);
        } else {
            Assert.isTrue(param.equals(paramInDb), CommonDomainConstants.CODE_NOT_DUPLICATE);
        }
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public void deleteById(String id) {
        serviceParamRepository.delete(id);
    }

    @Transactional(rollbackFor = RuntimeException.class)
    @Override
    public ServiceParam updateById(ServiceParam param) {
        Assert.notNull(param.getId(), CommonDomainConstants.ID_NOT_BLANK);
        checkCode(param);
        return serviceParamRepository.save(param);
    }

    @Override
    public ServiceParam findById(String id) {
        return serviceParamRepository.findOne(id);
    }

    @Override
    public Page<Map<String, Object>> sliceQuery(ServiceParamQueryRequest queryRequest) {
        Assert.notNull(queryRequest.getServiceId(), "服务id不能为空");
        return serviceParamMapper.sliceQuery(queryRequest);
    }

    @Override
    public List<Map<String, Object>> queryInParamMapping(ServiceParamMappingQueryRequest queryRequest) {
        if (queryRequest.getServiceId() == null) {
            return Collections.emptyList();
        }
        Assert.notNull(queryRequest.getProcdefId(), "流程定义id不能为空");
        Assert.notNull(queryRequest.getActivityCode(), "流程节点编码不能为空");
        return serviceParamMapper.queryInParamMapping(queryRequest);
    }

    @Override
    public List<Map<String, Object>> queryOutParamMapping(ServiceParamMappingQueryRequest queryRequest) {
        if (queryRequest.getServiceId() == null) {
            return Collections.emptyList();
        }
        Assert.notNull(queryRequest.getProcdefId(), "流程定义id不能为空");
        Assert.notNull(queryRequest.getActivityCode(), "流程节点编码不能为空");
        return serviceParamMapper.queryOutParamMapping(queryRequest);
    }
}
