package com.huigou.bpm.management.application;

import com.huigou.bpm.management.domain.model.ProcessVariable;
import com.huigou.bpm.management.domain.query.ProcessVariableQueryRequest;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author yonghuan
 */
public interface ProcessVariableApplication {

    ProcessVariable add(ProcessVariable variable);

    ProcessVariable updateById(ProcessVariable variable);

    void deleteById(String id);

    ProcessVariable findById(String id);

    Page<?> sliceQuery(ProcessVariableQueryRequest queryRequest);

    /**
     * 根据流程定义id查询流程定义的变量
     *
     * @param procdefId 流程定义id
     * @return 流程变量
     */
    List<ProcessVariable> findByProcdefId(String procdefId);
}
