package com.huigou.bpm.management.application;

import com.huigou.bpm.management.domain.model.ProcessDefinition;
import com.huigou.bpm.management.domain.model.ServiceMapping;
import com.huigou.bpm.management.domain.model.ServiceParamMapping;
import com.huigou.bpm.management.domain.model.ServiceRegistration;
import com.huigou.bpm.management.domain.query.ProcessDefinitionQueryRequest;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * BPM 流程定义管理
 *
 * @author yonghuan
 * @since 1.1.3
 */
public interface ProcessDefinitionApplication {

    /**
     * 新增一个流程定义
     *
     * @param processDefinition 流程定义
     * @return 被添加的流程定义
     */
    ProcessDefinition add(ProcessDefinition processDefinition);

    /**
     * 根据id查询流程定义
     *
     * @param id 流程定义id
     * @return 流程定义
     */
    ProcessDefinition queryById(String id);

    /**
     * 根据流程定义code查询流程定义
     *
     * @param code 流程定义code
     * @return 流程定义
     */
    ProcessDefinition queryByCode(String code);

    /**
     * 分页查询流程定义
     *
     * @param queryRequest 查询条件
     * @return 流程定义
     */
    Page<?> sliceQueryProcessDefinition(ProcessDefinitionQueryRequest queryRequest);

    /**
     * 查询流程定义分类
     *
     * @param parentId 父分类id
     * @return 流程定义分类
     */
    List<?> queryProcessDefinitionKind(String parentId);

    /**
     * 删除流程定义分类
     *
     * @param id 流程定义分类id
     */
    void deleteProcessDefinitionKind(String id);

    /**
     * 删除流程定义
     *
     * @param ids 流程定义id
     */
    void deleteProcessDefinition(List<String> ids);


    /**
     * 移动流程定义
     *
     * @param ids      流程定义id
     * @param parentId 分类id
     */
    void moveProcessDefinition(List<String> ids, String parentId);

    /**
     * 修改流程定义分类
     *
     * @param definitionKind 流程定义分类
     * @return 被修改的流程定义分类
     */
    ProcessDefinition updateProcessDefinitionKind(ProcessDefinition definitionKind);

    ProcessDefinition updateProcessDefinitionById(ProcessDefinition definition);

    /**
     * 修改流程定义或者流程定义分类的排序号
     *
     * @param idAndSequencePair idAndSequencePair
     */
    void updateSequence(Map<String, Integer> idAndSequencePair);

    /**
     * 修改流程定义状态。
     *
     * @param ids    流程定义id
     * @param status 状态，{@link com.huigou.domain.ValidStatus}
     */
    void updateStatus(List<String> ids, Integer status);

    /**
     * 查询流程定义分类
     *
     * @param id 流程定义分类id
     * @return 流程定义分类
     */
    ProcessDefinition queryProcessDefinitionKindById(String id);


    void bindService(ServiceMapping mapping, List<ServiceParamMapping> paramMappings);

    void clearService(String procdefId, String activityCode);

    ServiceRegistration queryServiceByActivityCode(String procdefId, String activityCode);
}
