package com.huigou.bpm.engine.processor;

import com.huigou.bpm.engine.application.BusinessProcessApplication;
import com.huigou.bpm.engine.domain.InMessage;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * 处理启动BPM流程请求。
 *
 * @author yonghuan
 */
public class StartProcessProcessor extends AbstractBusinessProcessor {

    private BusinessProcessApplication businessProcessApplication;

    @Autowired
    public void setBusinessProcessApplication(BusinessProcessApplication businessProcessApplication) {
        this.businessProcessApplication = businessProcessApplication;
    }

    @Override
    protected Map<String, Object> processInternal(InMessage inMessage) {
        String procInstId = businessProcessApplication.startProcessByCode(inMessage.getProcdefCode(), inMessage.getBizKey(), inMessage.getName(), inMessage.getDescription(), inMessage.getBizData());
        Map<String, Object> result = new HashMap<>(1);
        result.put("procInstId", procInstId);
        return result;
    }
}
