package com.huigou.bpm.engine.processor;

import com.huigou.bpm.engine.application.BusinessProcessApplication;
import com.huigou.bpm.engine.domain.InMessage;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.Map;

/**
 * @author yonghuan
 */
public class CompleteTaskProcessor extends AbstractBusinessProcessor {

    private BusinessProcessApplication businessProcessApplication;

    @Autowired
    public void setBusinessProcessApplication(BusinessProcessApplication businessProcessApplication) {
        this.businessProcessApplication = businessProcessApplication;
    }

    @Override
    protected Map<String, Object> processInternal(InMessage msg) {
        businessProcessApplication.completeTask(msg.getProcdefCode(), msg.getBizKey(), msg.getServiceCode(), msg.getBizData());
        return Collections.emptyMap();
    }
}
