package com.huigou.bpm.engine.domain.model;

import com.huigou.data.domain.model.AbstractEntity;
import com.topsunit.query.annotations.Dictionary;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * @author yonghuan
 */
@Table(name = "tbpm_biz_task")
@Entity
public class BizTask extends AbstractEntity {

    /**
     * 流程实例id
     */
    @Column(name = "proc_inst_id")
    private String procInstId;
    /**
     * 业务节点编码
     */
    @Column(name = "service_code")
    private String serviceCode;
    /**
     * 开始时间
     */
    @Column(name = "start_date")
    private Date startDate;
    @Column(name = "end_date")
    /**
     * 结束时间。
     */
    private Date endDate;
    /**
     * 开始处理时间
     */
    @Column(name = "take_date")
    private Date takeDate;
    /**
     * 状态。
     */
    @Dictionary("bizTaskStatus")
    private Integer status;
    /**
     * 限制时间。
     */
    @Column(name = "limit_date")
    private Date limitDate;
    /**
     * 已耗时（毫秒）
     */
    @Transient
    private Long duration;
    /**
     * 是否需要做超时检查
     */
    @Column(name = "timeout_check")
    private Boolean timeoutCheck;

    public String getProcInstId() {
        return procInstId;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    public String getServiceCode() {
        return serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getTakeDate() {
        return takeDate;
    }

    public void setTakeDate(Date takeDate) {
        this.takeDate = takeDate;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getLimitDate() {
        return limitDate;
    }

    public void setLimitDate(Date limitDate) {
        this.limitDate = limitDate;
    }

    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Boolean getTimeoutCheck() {
        return timeoutCheck;
    }

    public void setTimeoutCheck(Boolean timeoutCheck) {
        this.timeoutCheck = timeoutCheck;
    }

    /**
     * 业务任务状态。
     *
     * @author yonghuan
     */
    public enum Status {
        /**
         * 已经开始。
         */
        START(1),
        /**
         * 已经开始处理。
         */
        TAKE(2),
        /**
         * 已经结束。
         */
        END(3);
        public final int id;

        Status(int id) {
            this.id = id;
        }
    }
}
