package com.huigou.bpm.engine.delegate;

import com.huigou.bpm.engine.domain.model.BizTask;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author yonghuan
 */
public class BizTaskListenerComposition implements BizTaskListener {

    private List<BizTaskListener> listeners;

    public void setListeners(List<BizTaskListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void notify(String eventName, BizTask bizTask) {
        if (CollectionUtils.isEmpty(listeners)) {
            return;
        }
        listeners.forEach(listener -> listener.notify(eventName, bizTask));
    }
}
