package com.huigou.uasp.bmp.opm.controller;

import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.opm.application.IconApplication;
import com.huigou.uasp.bmp.opm.domain.model.resource.Icon;
import com.huigou.uasp.client.CommonController;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 图标。
 *
 * @author yonghuan
 */
@ControllerMapping("icon")
@Controller
public class IconController extends CommonController {

    @Autowired
    private IconApplication iconApplication;
    @Value("${icon.cssFile}")
    private String iconCssFile;

    /**
     * 同步图标
     */
    public String syncIcons() throws IOException, CSSException {
        String cssFile = getRequest().getRealPath(iconCssFile);
        String css = Files.readAllLines(Paths.get(cssFile))
                .stream()
                .collect(Collectors.joining("\n"));
        StyleSheet sheet = CSSFactory.parseString(css, null);
        List<Icon> icons = sheet.stream().filter(block -> block instanceof RuleSet)
                .map(RuleSet.class::cast)
                .filter(rule -> rule.getSelectors().length == 1)
                .filter(rule -> rule.size() == 1)
                .filter(rule -> "content".equals(rule.get(0).getProperty()))
                .map(rule -> rule.getSelectors()[0].get(0).getClassName())
                .map(className -> new Icon(className, String.format("<i class='fa %s'></i>", className)))
                .collect(Collectors.toList());
        iconApplication.syncIcons(icons);
        return success();
    }

}
