import request from '@/utils/request'

// 查询客户SAP特性信息列表
export function listSapdata(query) {
  return request({
    url: '/md/sapPropertyData/list',
    method: 'get',
    params: query
  })
}

// 查询客户SAP特性信息详细
export function getSapdata(id) {
  return request({
    url: '/md/sapPropertyData/' + id,
    method: 'get'
  })
}

// 新增客户SAP特性信息
export function addSapdata(data) {
  return request({
    url: '/md/sapPropertyData',
    method: 'post',
    data: data
  })
}

// 修改客户SAP特性信息
export function updateSapdata(data) {
  return request({
    url: '/md/sapPropertyData',
    method: 'put',
    data: data
  })
}

// 删除客户SAP特性信息
export function delSapdata(id) {
  return request({
    url: '/md/sapPropertyData/' + id,
    method: 'delete'
  })
}

//上传给sap
export function uploadSapdata(id,relationId) {
  return request({
    url: '/md/sapPropertyData/uploadSapdata/' +id +'/' + relationId,
    method: 'get'
  })
}
