import request from '@/utils/request'

// 查询作业端版本记录列表
export function listConfig(query) {
  return request({
    url: '/md/appconfig/list',
    method: 'get',
    params: query
  })
}

// 查询作业端版本记录详细
export function getConfig(id) {
  return request({
    url: '/md/appconfig/' + id,
    method: 'get'
  })
}

// 新增作业端版本记录
export function addConfig(data) {
  return request({
    url: '/md/appconfig',
    method: 'post',
    data: data
  })
}

// 修改作业端版本记录
export function updateConfig(data) {
  return request({
    url: '/md/appconfig',
    method: 'put',
    data: data
  })
}

// 删除作业端版本记录
export function delConfig(id) {
  return request({
    url: '/md/appconfig/' + id,
    method: 'delete'
  })
}
