import request from '@/utils/request'

// 查询刀模版申请单列表
export function listTmToolRequest(query) {
  return request({
    url: '/tm/tmToolRequest/list',
    method: 'get',
    params: query
  })
}

// 查询刀模版申请单详细
export function getTmToolRequest(toolRequestId) {
  return request({
    url: '/tm/tmToolRequest/' + toolRequestId,
    method: 'get'
  })
}

// 新增刀模版申请单
export function addTmToolRequest(data) {
  return request({
    url: '/tm/tmToolRequest',
    method: 'post',
    data: data
  })
}

// 修改刀模版申请单
export function updateTmToolRequest(data) {
  return request({
    url: '/tm/tmToolRequest',
    method: 'put',
    data: data
  })
}

// 删除刀模版申请单
export function delTmToolRequest(toolRequestId) {
  return request({
    url: '/tm/tmToolRequest/' + toolRequestId,
    method: 'delete'
  })
}
