import request from '@/utils/request'

// 查询生产工单列表
export function listWorkorder(query) {
  return request({
    url: '/mes/pro/workorder/list',
    method: 'get',
    params: query
  })
}

// 查询补单工单工单编码接口
export function getMakeWorkorderCode(code) {
  return request({
    url: `/mes/pro/workorder/getChildWorkorderCode/${code}`,
    method: 'get'
  })
}

// 查询生产工单详细
export function getWorkorder(workorderId) {
  return request({
    url: '/mes/pro/workorder/' + workorderId,
    method: 'get'
  })
}

// 查询生产工单工序列表
export function getProWorkOrderProcessList(query) {
  return request({
    url: "/pro/proWorkOrderProcess/list",
    method: "get",
    params: query
  });
}

// 打样生产工单任务生成
export function workorderProofMakeProduction(data) {
  return request({
    url: "/mes/pro/workorder/proofMakeProduction",
    method: "post",
    data: data,
  });
}

// 新增生产工单
export function addWorkorder(data) {
  return request({
    url: '/mes/pro/workorder',
    method: 'post',
    data: data
  })
}

// 提交补单工单
export function makeSubmitWorkorder(data) {
  return request({
    url: "/mes/pro/workorder/addComplements",
    method: "post",
    data: data,
  });
}

// 修改生产工单
export function updateWorkorder(data) {
  return request({
    url: '/mes/pro/workorder',
    method: 'put',
    data: data
  })
}

// 关闭生产工单
export function closeWorkorder(data) {
  return request({
    url: '/mes/pro/workorder/close',
    method: 'put',
    data: data
  })
}

// 删除生产工单
export function delWorkorder(workorderId) {
  return request({
    url: '/mes/pro/workorder/' + workorderId,
    method: 'delete'
  })
}

// 查询物料依赖列表
export function listItems(query) {
  return request({
    url: '/mes/pro/workorder/listItems',
    method: 'get',
    params: query
  })
}

export function dofinish(workorderId){
  return request({
    url: '/mes/pro/workorder/'+workorderId,
    method: 'put'
  })
}

export function doCheckToolNum(workorderId){
  return request({
    url: '/mes/pro/workorder/checkToolNum',
    data: {'workorderIds' : workorderId},
    method: 'post'
  })
}

  //单个完成工单，将草稿->已确认
  export function confirmedWorkorder(workorderId){
    return request({
      url: '/mes/pro/workorder/setStatus/'+workorderId,
      method: 'get'
    })
}

// 获取打印工单数据
export function printInfo(workorderId) {
  return request({
    url: '/mes/pro/workorder/printInfo?workorderIds=' + workorderId,
    method: 'get'
  })
}
