import request from '@/utils/request'

// 查询打样申请工序物料列表
export function listPrototypeRequestProcessItem(query) {
  return request({
    url: '/mes/pro/prototypeRequestProcessItem/list',
    method: 'get',
    params: query
  })
}

// 查询打样申请工序物料详细
export function getPrototypeRequestProcessItem(prototypeRequestProcessItemId) {
  return request({
    url: '/mes/pro/prototypeRequestProcessItem/' + prototypeRequestProcessItemId,
    method: 'get'
  })
}

// 新增打样申请工序物料
export function addPrototypeRequestProcessItem(data) {
  return request({
    url: '/mes/pro/prototypeRequestProcessItem',
    method: 'post',
    data: data
  })
}

// 修改打样申请工序物料
export function updatePrototypeRequestProcessItem(data) {
  return request({
    url: '/mes/pro/prototypeRequestProcessItem',
    method: 'put',
    data: data
  })
}

// 删除打样申请工序物料
export function delPrototypeRequestProcessItem(prototypeRequestProcessItemId) {
  return request({
    url: '/mes/pro/prototypeRequestProcessItem/' + prototypeRequestProcessItemId,
    method: 'delete'
  })
}
