import request from "@/utils/request";

// 查询生产版本列表
export function listProductionSolution(query) {
  return request({
    url: "pro/productionSolution/list",
    method: "get",
    params: query,
  });
}

// 查询生产版本详细
export function getProductionSolution(productionSolutionId) {
  return request({
    url: "pro/productionSolution/" + productionSolutionId,
    method: "get",
  });
}

// 新增生产版本
export function addProductionSolution(data) {
  return request({
    url: "pro/productionSolution",
    method: "post",
    data: data,
  });
}

// 修改生产版本
export function updateProductionSolution(data) {
  return request({
    url: "pro/productionSolution",
    method: "put",
    data: data,
  });
}

// 删除生产版本
export function delProductionSolution(productionSolutionId) {
  return request({
    url: "pro/productionSolution/" + productionSolutionId,
    method: "delete",
  });
}
// 提交生产版本
export function submitProductionSolution(data) {
  return request({
    url: "pro/productionSolution/submit",
    method: "put",
    data: data,
  });
}
