import request from '@/utils/request'

// 查询生产BOM列表
export function listBom(query) {
  return request({
    url: '/mes/pro/bom/list',
    method: 'get',
    params: query
  })
}

// 查询所有有效生产BOM
export function listAllBom() {
  return request({
    url: '/mes/pro/bom/listAll',
    method: 'get'
  })
}


// 查询生产BOM详细
export function getBom(bomId) {
  return request({
    url: '/mes/pro/bom/' + bomId,
    method: 'get'
  })
}

// 新增生产BOM
export function addBom(data) {
  return request({
    url: '/mes/pro/bom',
    method: 'post',
    data: data
  })
}

// 修改生产BOM
export function updateBom(data) {
  return request({
    url: '/mes/pro/bom',
    method: 'put',
    data: data
  })
}

// 删除生产BOM
export function delBom(bomId) {
  return request({
    url: '/mes/pro/bom/' + bomId,
    method: 'delete'
  })
}
