import request from '@/utils/request'

// 查询销售订单详情列表
export function listDetail(query) {
  return request({
    url: '/od/salesOrderDetail/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单详情详细
export function getDetail(id) {
  return request({
    url: '/od/salesOrderDetail/' + id,
    method: 'get'
  })
}

// 新增销售订单详情
export function addDetail(data) {
  return request({
    url: '/od/salesOrderDetail',
    method: 'post',
    data: data
  })
}

// 修改销售订单详情
export function updateDetail(data) {
  return request({
    url: '/od/salesOrderDetail',
    method: 'put',
    data: data
  })
}

// 删除销售订单详情
export function delDetail(id) {
  return request({
    url: '/od/salesOrderDetail/' + id,
    method: 'delete'
  })
}
